/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.gerrit.reviewdb.client.CurrentSchemaVersion;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.schema.Schema_161;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcExecutor;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.gwtorm.server.StatementExecutor;
import com.google.inject.Provider;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class SchemaVersion {
    public static final Class<Schema_161> C = Schema_161.class;
    private final Provider<? extends SchemaVersion> prior;
    private final int versionNbr;

    public static int getBinaryVersion() {
        return SchemaVersion.guessVersion(C);
    }

    protected SchemaVersion(Provider<? extends SchemaVersion> prior) {
        this.prior = prior;
        this.versionNbr = SchemaVersion.guessVersion(this.getClass());
    }

    public static int guessVersion(Class<?> c) {
        String n = c.getName();
        n = n.substring(n.lastIndexOf(95) + 1);
        while (n.startsWith("0")) {
            n = n.substring(1);
        }
        return Integer.parseInt(n);
    }

    public final int getVersionNbr() {
        return this.versionNbr;
    }

    @VisibleForTesting
    public final SchemaVersion getPrior() {
        return this.prior.get();
    }

    public final void check(UpdateUI ui, CurrentSchemaVersion curr, SchemaFactory<ReviewDb> schema) throws OrmException, SQLException {
        if (curr.versionNbr != this.versionNbr) {
            if (curr.versionNbr > this.versionNbr) {
                throw new OrmException("Cannot downgrade database schema from version " + curr.versionNbr + " to " + this.versionNbr + ".");
            }
            this.upgradeFrom(ui, curr, schema);
        }
    }

    private void upgradeFrom(UpdateUI ui, CurrentSchemaVersion curr, SchemaFactory<ReviewDb> schema) throws OrmException, SQLException {
        List<SchemaVersion> pending = this.pending(curr.versionNbr);
        try (ReviewDb db = ReviewDbUtil.unwrapDb(schema.open());){
            this.updateSchema(pending, ui, db);
        }
        this.migrateData(pending, ui, curr, schema);
        db = ReviewDbUtil.unwrapDb(schema.open());
        try {
            JdbcSchema s = (JdbcSchema)((Object)db);
            final ArrayList<String> pruneList = new ArrayList<String>();
            s.pruneSchema(new StatementExecutor(){

                @Override
                public void execute(String sql) {
                    pruneList.add(sql);
                }

                @Override
                public void close() {
                }
            });
            try (JdbcExecutor e = new JdbcExecutor(s);){
                if (!pruneList.isEmpty()) {
                    ui.pruneSchema(e, pruneList);
                }
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
    }

    private List<SchemaVersion> pending(int curr) {
        ArrayList<SchemaVersion> r = Lists.newArrayListWithCapacity(this.versionNbr - curr);
        SchemaVersion v = this;
        while (curr < v.getVersionNbr()) {
            r.add(v);
            v = v.prior.get();
        }
        Collections.reverse(r);
        return r;
    }

    private void updateSchema(List<SchemaVersion> pending, UpdateUI ui, ReviewDb db) throws OrmException, SQLException {
        for (SchemaVersion v : pending) {
            ui.message(String.format("Upgrading schema to %d ...", v.getVersionNbr()));
            v.preUpdateSchema(db);
        }
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.updateSchema(e);
        }
    }

    protected void preUpdateSchema(ReviewDb db) throws OrmException, SQLException {
    }

    private void migrateData(List<SchemaVersion> pending, UpdateUI ui, CurrentSchemaVersion curr, SchemaFactory<ReviewDb> schema) throws OrmException, SQLException {
        for (SchemaVersion v : pending) {
            Stopwatch sw = Stopwatch.createStarted();
            ui.message(String.format("Migrating data to schema %d ...", v.getVersionNbr()));
            try (ReviewDb db = ReviewDbUtil.unwrapDb(schema.open());){
                v.migrateData(db, ui);
            }
            db = ReviewDbUtil.unwrapDb(schema.open());
            try {
                v.finish(curr, db);
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
            ui.message(String.format("\t> Done (%.3f s)", (double)sw.elapsed(TimeUnit.MILLISECONDS) / 1000.0));
        }
    }

    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
    }

    protected void finish(CurrentSchemaVersion curr, ReviewDb db) throws OrmException {
        curr.versionNbr = this.versionNbr;
        db.schemaVersion().update(Collections.singleton(curr));
    }

    protected static void renameTable(ReviewDb db, String from, String to) throws OrmException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.renameTable(e, from, to);
        }
    }

    protected static void renameColumn(ReviewDb db, String table, String from, String to) throws OrmException {
        JdbcSchema s = (JdbcSchema)((Object)db);
        try (JdbcExecutor e = new JdbcExecutor(s);){
            s.renameColumn(e, table, from, to);
        }
    }

    protected static void execute(ReviewDb db, String sql) throws SQLException {
        try (Statement s = SchemaVersion.newStatement(db);){
            s.execute(sql);
        }
    }

    protected static Statement newStatement(ReviewDb db) throws SQLException {
        return ((JdbcSchema)((Object)db)).getConnection().createStatement();
    }

    protected static PreparedStatement prepareStatement(ReviewDb db, String sql) throws SQLException {
        return ((JdbcSchema)((Object)db)).getConnection().prepareStatement(sql);
    }

    protected static JdbcExecutor newExecutor(ReviewDb db) throws OrmException {
        return new JdbcExecutor(((JdbcSchema)((Object)db)).getConnection());
    }
}

