/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.Streams;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_150;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Schema_151
extends SchemaVersion {
    @Inject
    protected Schema_151(Provider<Schema_150> prior) {
        super(prior);
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        List<AccountGroup> accountGroups = db.accountGroups().all().toList();
        for (AccountGroup accountGroup : accountGroups) {
            ResultSet<AccountGroupMemberAudit> groupMemberAudits = db.accountGroupMembersAudit().byGroup(accountGroup.getId());
            Optional<Timestamp> firstTimeMentioned = Streams.stream(groupMemberAudits).map(AccountGroupMemberAudit::getKey).map(AccountGroupMemberAudit.Key::getAddedOn).min(Comparator.naturalOrder());
            Timestamp createdOn = firstTimeMentioned.orElseGet(() -> AccountGroup.auditCreationInstantTs());
            accountGroup.setCreatedOn(createdOn);
        }
        db.accountGroups().update(accountGroups);
    }
}

