/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.securestore;

import com.google.gerrit.common.FileUtil;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.securestore.SecureStore;
import com.google.inject.Inject;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

@Singleton
public class DefaultSecureStore
extends SecureStore {
    private final FileBasedConfig sec;
    private final Map<String, FileBasedConfig> pluginSec;
    private final SitePaths site;

    @Inject
    DefaultSecureStore(SitePaths site) {
        this.site = site;
        this.sec = new FileBasedConfig(site.secure_config.toFile(), FS.DETECTED);
        try {
            this.sec.load();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RuntimeException("Cannot load secure.config", e);
        }
        this.pluginSec = new HashMap<String, FileBasedConfig>();
    }

    @Override
    public String[] getList(String section, String subsection, String name) {
        return this.sec.getStringList(section, subsection, name);
    }

    @Override
    public synchronized String[] getListForPlugin(String pluginName, String section, String subsection, String name) {
        FileBasedConfig cfg = null;
        if (this.pluginSec.containsKey(pluginName)) {
            cfg = this.pluginSec.get(pluginName);
        } else {
            String filename = pluginName + ".secure.config";
            File pluginConfigFile = this.site.etc_dir.resolve(filename).toFile();
            if (pluginConfigFile.exists()) {
                cfg = new FileBasedConfig(pluginConfigFile, FS.DETECTED);
                try {
                    cfg.load();
                    this.pluginSec.put(pluginName, cfg);
                }
                catch (IOException | ConfigInvalidException e) {
                    throw new RuntimeException("Cannot load " + filename, e);
                }
            }
        }
        return cfg != null ? cfg.getStringList(section, subsection, name) : null;
    }

    @Override
    public void setList(String section, String subsection, String name, List<String> values) {
        if (values != null) {
            this.sec.setStringList(section, subsection, name, values);
        } else {
            this.sec.unset(section, subsection, name);
        }
        this.save();
    }

    @Override
    public void unset(String section, String subsection, String name) {
        this.sec.unset(section, subsection, name);
        this.save();
    }

    @Override
    public Iterable<SecureStore.EntryKey> list() {
        ArrayList<SecureStore.EntryKey> result = new ArrayList<SecureStore.EntryKey>();
        for (String section : this.sec.getSections()) {
            for (String subsection : this.sec.getSubsections(section)) {
                for (String name : this.sec.getNames(section, subsection)) {
                    result.add(new SecureStore.EntryKey(section, subsection, name));
                }
            }
            for (String name : this.sec.getNames(section)) {
                result.add(new SecureStore.EntryKey(section, null, name));
            }
        }
        return result;
    }

    @Override
    public boolean isOutdated() {
        return this.sec.isOutdated();
    }

    @Override
    public void reload() {
        try {
            this.sec.load();
        }
        catch (IOException | ConfigInvalidException e) {
            throw new ProvisionException("Couldn't reload secure.config", e);
        }
    }

    private void save() {
        try {
            DefaultSecureStore.saveSecure(this.sec);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot save secure.config", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSecure(FileBasedConfig sec) throws IOException {
        if (FileUtil.modified(sec)) {
            byte[] out = Constants.encode(sec.toText());
            File path = sec.getFile();
            LockFile lf = new LockFile(path);
            if (!lf.lock()) {
                throw new IOException("Cannot lock " + path);
            }
            try {
                FileUtil.chmod(384, new File(path.getParentFile(), path.getName() + ".lock"));
                lf.write(out);
                if (!lf.commit()) {
                    throw new IOException("Cannot commit write to " + path);
                }
            }
            finally {
                lf.unlock();
            }
        }
    }
}

