/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.NoSuchRefException;
import com.google.gerrit.server.update.BatchUpdateListener;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.InsertChangeOp;
import com.google.gerrit.server.update.NoteDbBatchUpdate;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.RepoView;
import com.google.gerrit.server.update.ReviewDbBatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.PushCertificate;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchUpdate
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BatchUpdate.class);
    protected GitRepositoryManager repoManager;
    protected final Project.NameKey project;
    protected final CurrentUser user;
    protected final Timestamp when;
    protected final TimeZone tz;
    protected final ListMultimap<Change.Id, BatchUpdateOp> ops = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    protected final Map<Change.Id, Change> newChanges = new HashMap<Change.Id, Change>();
    protected final List<RepoOnlyOp> repoOnlyOps = new ArrayList<RepoOnlyOp>();
    protected RepoView repoView;
    protected BatchRefUpdate batchRefUpdate;
    protected Order order;
    protected OnSubmitValidators onSubmitValidators;
    protected RequestId requestId;
    protected PushCertificate pushCert;
    protected String refLogMessage;
    private boolean updateChangesInParallel;

    public static Module module() {
        return new FactoryModule(){

            @Override
            public void configure() {
                this.factory(ReviewDbBatchUpdate.AssistedFactory.class);
                this.factory(NoteDbBatchUpdate.AssistedFactory.class);
            }
        };
    }

    static void setRequestIds(Collection<? extends BatchUpdate> updates, @Nullable RequestId requestId) {
        if (requestId != null) {
            for (BatchUpdate batchUpdate : updates) {
                Preconditions.checkArgument(batchUpdate.requestId == null || batchUpdate.requestId == requestId, "refusing to overwrite RequestId %s in update with %s", (Object)batchUpdate.requestId, (Object)requestId);
                batchUpdate.setRequestId(requestId);
            }
        }
    }

    static Order getOrder(Collection<? extends BatchUpdate> updates, BatchUpdateListener listener) {
        Order o = null;
        for (BatchUpdate batchUpdate : updates) {
            if (o == null) {
                o = batchUpdate.order;
                continue;
            }
            if (batchUpdate.order == o) continue;
            throw new IllegalArgumentException("cannot mix execution orders");
        }
        if (o != Order.REPO_BEFORE_DB) {
            Preconditions.checkArgument(listener == BatchUpdateListener.NONE, "BatchUpdateListener not supported for order %s", (Object)o);
        }
        return o;
    }

    static boolean getUpdateChangesInParallel(Collection<? extends BatchUpdate> updates) {
        Preconditions.checkArgument(!updates.isEmpty());
        Boolean p = null;
        for (BatchUpdate batchUpdate : updates) {
            if (p == null) {
                p = batchUpdate.updateChangesInParallel;
                continue;
            }
            if (batchUpdate.updateChangesInParallel == p) continue;
            throw new IllegalArgumentException("cannot mix parallel and non-parallel operations");
        }
        Preconditions.checkArgument(p == false || updates.size() <= 1, "cannot execute ChangeOps in parallel with more than 1 BatchUpdate");
        return p;
    }

    static void wrapAndThrowException(Exception e) throws UpdateException, RestApiException {
        Throwables.throwIfUnchecked(e);
        Throwables.throwIfInstanceOf(e, UpdateException.class);
        Throwables.throwIfInstanceOf(e, RestApiException.class);
        if (e instanceof InvalidChangeOperationException) {
            throw new ResourceConflictException(e.getMessage(), e);
        }
        if (e instanceof NoSuchChangeException || e instanceof NoSuchRefException || e instanceof NoSuchProjectException) {
            throw new ResourceNotFoundException(e.getMessage(), e);
        }
        throw new UpdateException(e);
    }

    protected BatchUpdate(GitRepositoryManager repoManager, PersonIdent serverIdent, Project.NameKey project, CurrentUser user, Timestamp when) {
        this.repoManager = repoManager;
        this.project = project;
        this.user = user;
        this.when = when;
        this.tz = serverIdent.getTimeZone();
        this.order = Order.REPO_BEFORE_DB;
    }

    @Override
    public void close() {
        if (this.repoView != null) {
            this.repoView.close();
        }
    }

    public abstract void execute(BatchUpdateListener var1) throws UpdateException, RestApiException;

    public void execute() throws UpdateException, RestApiException {
        this.execute(BatchUpdateListener.NONE);
    }

    protected abstract Context newContext();

    public BatchUpdate setRequestId(RequestId requestId) {
        this.requestId = requestId;
        return this;
    }

    public BatchUpdate setRepository(Repository repo, RevWalk revWalk, ObjectInserter inserter) {
        Preconditions.checkState(this.repoView == null, "repo already set");
        this.repoView = new RepoView(repo, revWalk, inserter);
        return this;
    }

    public BatchUpdate setPushCertificate(@Nullable PushCertificate pushCert) {
        this.pushCert = pushCert;
        return this;
    }

    public BatchUpdate setRefLogMessage(@Nullable String refLogMessage) {
        this.refLogMessage = refLogMessage;
        return this;
    }

    public BatchUpdate setOrder(Order order) {
        this.order = order;
        return this;
    }

    public BatchUpdate setOnSubmitValidators(OnSubmitValidators onSubmitValidators) {
        this.onSubmitValidators = onSubmitValidators;
        return this;
    }

    public BatchUpdate updateChangesInParallel() {
        this.updateChangesInParallel = true;
        return this;
    }

    protected void initRepository() throws IOException {
        if (this.repoView == null) {
            this.repoView = new RepoView(this.repoManager, this.project);
        }
    }

    protected RepoView getRepoView() throws IOException {
        this.initRepository();
        return this.repoView;
    }

    protected CurrentUser getUser() {
        return this.user;
    }

    protected Optional<Account> getAccount() {
        return this.user.isIdentifiedUser() ? Optional.of(this.user.asIdentifiedUser().getAccount()) : Optional.empty();
    }

    protected RevWalk getRevWalk() throws IOException {
        this.initRepository();
        return this.repoView.getRevWalk();
    }

    public Map<String, ReceiveCommand> getRefUpdates() {
        return this.repoView != null ? this.repoView.getCommands().getCommands() : ImmutableMap.of();
    }

    public BatchUpdate addOp(Change.Id id, BatchUpdateOp op) {
        Preconditions.checkArgument(!(op instanceof InsertChangeOp), "use insertChange");
        Preconditions.checkNotNull(op);
        this.ops.put(id, op);
        return this;
    }

    public BatchUpdate addRepoOnlyOp(RepoOnlyOp op) {
        Preconditions.checkArgument(!(op instanceof BatchUpdateOp), "use addOp()");
        this.repoOnlyOps.add(op);
        return this;
    }

    public BatchUpdate insertChange(InsertChangeOp op) throws IOException {
        Context ctx = this.newContext();
        Change c = op.createChange(ctx);
        Preconditions.checkArgument(!this.newChanges.containsKey(c.getId()), "only one op allowed to create change %s", (Object)c.getId());
        this.newChanges.put(c.getId(), c);
        this.ops.get((Object)c.getId()).add(0, op);
        return this;
    }

    protected void logDebug(String msg, Throwable t) {
        if (this.requestId != null && log.isDebugEnabled()) {
            log.debug(this.requestId + msg, t);
        }
    }

    protected void logDebug(String msg, Object ... args) {
        if (this.requestId != null && log.isDebugEnabled()) {
            log.debug(this.requestId + msg, args);
        }
    }

    @Singleton
    public static class Factory {
        private final NotesMigration migration;
        private final ReviewDbBatchUpdate.AssistedFactory reviewDbBatchUpdateFactory;
        private final NoteDbBatchUpdate.AssistedFactory noteDbBatchUpdateFactory;

        @Inject
        Factory(NotesMigration migration, ReviewDbBatchUpdate.AssistedFactory reviewDbBatchUpdateFactory, NoteDbBatchUpdate.AssistedFactory noteDbBatchUpdateFactory) {
            this.migration = migration;
            this.reviewDbBatchUpdateFactory = reviewDbBatchUpdateFactory;
            this.noteDbBatchUpdateFactory = noteDbBatchUpdateFactory;
        }

        public BatchUpdate create(ReviewDb db, Project.NameKey project, CurrentUser user, Timestamp when) {
            if (this.migration.disableChangeReviewDb()) {
                return this.noteDbBatchUpdateFactory.create(db, project, user, when);
            }
            return this.reviewDbBatchUpdateFactory.create(db, project, user, when);
        }

        public void execute(Collection<BatchUpdate> updates, BatchUpdateListener listener, @Nullable RequestId requestId, boolean dryRun) throws UpdateException, RestApiException {
            Preconditions.checkNotNull(listener);
            Factory.checkDifferentProject(updates);
            if (this.migration.disableChangeReviewDb()) {
                ImmutableList<BatchUpdate> noteDbUpdates = ImmutableList.copyOf(updates);
                NoteDbBatchUpdate.execute(noteDbUpdates, listener, requestId, dryRun);
            } else {
                ImmutableList<BatchUpdate> reviewDbUpdates = ImmutableList.copyOf(updates);
                ReviewDbBatchUpdate.execute(reviewDbUpdates, listener, requestId, dryRun);
            }
        }

        private static void checkDifferentProject(Collection<BatchUpdate> updates) {
            Multiset projectCounts = updates.stream().map(u -> u.project).collect(ImmutableMultiset.toImmutableMultiset());
            Preconditions.checkArgument(projectCounts.entrySet().size() == updates.size(), "updates must all be for different projects, got: %s", (Object)projectCounts);
        }
    }
}

