/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class RequestId {
    private static final String MACHINE_ID;
    private final String str;

    public static RequestId forChange(Change c) {
        return new RequestId(c.getId().toString());
    }

    public static RequestId forProject(Project.NameKey p) {
        return new RequestId(p.toString());
    }

    private RequestId(String resourceId) {
        Hasher h = Hashing.murmur3_128().newHasher();
        h.putLong(Thread.currentThread().getId()).putUnencodedChars(MACHINE_ID);
        this.str = "[" + resourceId + "-" + TimeUtil.nowTs().getTime() + "-" + h.hash().toString().substring(0, 8) + "]";
    }

    public String toString() {
        return this.str;
    }

    public String toStringForStorage() {
        return this.str.substring(1, this.str.length() - 1);
    }

    static {
        String id;
        try {
            id = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            id = "unknown";
        }
        MACHINE_ID = id;
    }
}

