/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.concurrent.Callable;

public abstract class ThreadLocalRequestScopePropagator<C>
extends RequestScopePropagator {
    private final ThreadLocal<C> threadLocal;

    protected ThreadLocalRequestScopePropagator(Scope scope, ThreadLocal<C> threadLocal, ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
        super(scope, local, dbProviderProvider);
        this.threadLocal = threadLocal;
    }

    @Override
    protected final <T> Callable<T> wrapImpl(Callable<T> callable) {
        C ctx = this.continuingContext(this.requireContext());
        return () -> {
            C old = this.threadLocal.get();
            this.threadLocal.set(ctx);
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                if (old != null) {
                    this.threadLocal.set(old);
                } else {
                    this.threadLocal.remove();
                }
            }
        };
    }

    private C requireContext() {
        C context = this.threadLocal.get();
        if (context == null) {
            throw new OutOfScopeException("Cannot access scoped object");
        }
        return context;
    }

    protected abstract C continuingContext(C var1);
}

