/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Atomics;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.args4j.SubcommandHandler;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandProvider;
import com.google.gerrit.sshd.SshExecuteCommandInterceptor;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.kohsuke.args4j.Argument;

final class DispatchCommand
extends BaseCommand {
    private final CurrentUser currentUser;
    private final PermissionBackend permissionBackend;
    private final Map<String, CommandProvider> commands;
    private final AtomicReference<Command> atomicCmd;
    private final DynamicSet<SshExecuteCommandInterceptor> commandInterceptors;
    @Argument(index=0, required=false, metaVar="COMMAND", handler=SubcommandHandler.class)
    private String commandName;
    @Argument(index=1, multiValued=true, metaVar="ARG")
    private List<String> args = new ArrayList<String>();

    @Inject
    DispatchCommand(CurrentUser user, PermissionBackend permissionBackend, DynamicSet<SshExecuteCommandInterceptor> commandInterceptors, @Assisted Map<String, CommandProvider> all) {
        this.currentUser = user;
        this.permissionBackend = permissionBackend;
        this.commands = all;
        this.atomicCmd = Atomics.newReference();
        this.commandInterceptors = commandInterceptors;
    }

    Map<String, CommandProvider> getMap() {
        return this.commands;
    }

    @Override
    public void start(Environment env) throws IOException {
        try {
            this.parseCommandLine();
            if (Strings.isNullOrEmpty(this.commandName)) {
                StringWriter msg = new StringWriter();
                msg.write(this.usage());
                throw this.die(msg.toString());
            }
            CommandProvider p = this.commands.get(this.commandName);
            if (p == null) {
                String msg = (this.getName().isEmpty() ? "Gerrit Code Review" : this.getName()) + ": " + this.commandName + ": not found";
                throw this.die(msg);
            }
            Command cmd = p.getProvider().get();
            this.checkRequiresCapability(cmd);
            String actualCommandName = this.commandName;
            if (cmd instanceof BaseCommand) {
                BaseCommand bc = (BaseCommand)cmd;
                if (!this.getName().isEmpty()) {
                    actualCommandName = this.getName() + " " + this.commandName;
                }
                bc.setName(actualCommandName);
                bc.setArguments(this.args.toArray(new String[this.args.size()]));
            } else if (!this.args.isEmpty()) {
                throw this.die(this.commandName + " does not take arguments");
            }
            for (SshExecuteCommandInterceptor commandInterceptor : this.commandInterceptors) {
                if (commandInterceptor.accept(actualCommandName, this.args)) continue;
                throw new BaseCommand.UnloggedFailure(126, String.format("blocked by %s, contact gerrit administrators for more details", commandInterceptor.name()));
            }
            this.provideStateTo(cmd);
            this.atomicCmd.set(cmd);
            cmd.start(env);
        }
        catch (BaseCommand.UnloggedFailure e) {
            String msg = e.getMessage();
            if (!msg.endsWith("\n")) {
                msg = msg + "\n";
            }
            this.err.write(msg.getBytes(ENC));
            this.err.flush();
            this.onExit(e.exitCode);
        }
    }

    private void checkRequiresCapability(Command cmd) throws BaseCommand.UnloggedFailure {
        String pluginName = null;
        if (cmd instanceof BaseCommand) {
            pluginName = ((BaseCommand)cmd).getPluginName();
        }
        try {
            this.permissionBackend.user(this.currentUser).checkAny(GlobalPermission.fromAnnotation(pluginName, cmd.getClass()));
        }
        catch (AuthException e) {
            throw new BaseCommand.UnloggedFailure(0x40000003, e.getMessage());
        }
        catch (PermissionBackendException e) {
            throw new BaseCommand.UnloggedFailure(1, "fatal: permission check unavailable", e);
        }
    }

    @Override
    public void destroy() {
        Command cmd = this.atomicCmd.getAndSet(null);
        if (cmd != null) {
            try {
                cmd.destroy();
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked(e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected String usage() {
        StringBuilder usage = new StringBuilder();
        usage.append("Available commands");
        if (!this.getName().isEmpty()) {
            usage.append(" of ");
            usage.append(this.getName());
        }
        usage.append(" are:\n");
        usage.append("\n");
        int maxLength = -1;
        for (String name : this.commands.keySet()) {
            maxLength = Math.max(maxLength, name.length());
        }
        String format = "%-" + maxLength + "s   %s";
        for (String name : Sets.newTreeSet(this.commands.keySet())) {
            CommandProvider p = this.commands.get(name);
            usage.append("   ");
            usage.append(String.format(format, name, Strings.nullToEmpty(p.getDescription())));
            usage.append("\n");
        }
        usage.append("\n");
        usage.append("See '");
        if (this.getName().indexOf(32) < 0) {
            usage.append(this.getName());
            usage.append(' ');
        }
        usage.append("COMMAND --help' for more information.\n");
        usage.append("\n");
        return usage.toString();
    }

    public String getCommandName() {
        return this.commandName;
    }

    static interface Factory {
        public DispatchCommand create(Map<String, CommandProvider> var1);
    }
}

