/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.eclipse.jgit.lib.Config;

class StreamCommandExecutorProvider
implements Provider<ScheduledThreadPoolExecutor> {
    private final int poolSize;
    private final WorkQueue queues;

    @Inject
    StreamCommandExecutorProvider(@GerritServerConfig Config config, WorkQueue wq) {
        int cores = Runtime.getRuntime().availableProcessors();
        this.poolSize = config.getInt("sshd", "streamThreads", cores + 1);
        this.queues = wq;
    }

    @Override
    public ScheduledThreadPoolExecutor get() {
        return this.queues.createQueue(this.poolSize, "SSH-Stream-Worker", 1, true);
    }
}

