/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.api.groups.GroupInput;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.AddSubgroups;
import com.google.gerrit.server.group.CreateGroup;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresCapability(value="createGroup")
@CommandMetaData(name="create-group", description="Create a new account group")
final class CreateGroupCommand
extends SshCommand {
    @Option(name="--owner", aliases={"-o"}, metaVar="GROUP", usage="owning group, if not specified the group will be self-owning")
    private AccountGroup.Id ownerGroupId;
    @Option(name="--description", aliases={"-d"}, metaVar="DESC", usage="description of group")
    private String groupDescription = "";
    @Argument(index=0, required=true, metaVar="GROUP", usage="name of group to be created")
    private String groupName;
    private final Set<Account.Id> initialMembers = new HashSet<Account.Id>();
    @Option(name="--visible-to-all", usage="to make the group visible to all registered users")
    private boolean visibleToAll;
    private final Set<AccountGroup.UUID> initialGroups = new HashSet<AccountGroup.UUID>();
    @Inject
    private CreateGroup.Factory createGroupFactory;
    @Inject
    private GroupsCollection groups;
    @Inject
    private AddMembers addMembers;
    @Inject
    private AddSubgroups addSubgroups;

    CreateGroupCommand() {
    }

    @Option(name="--member", aliases={"-m"}, metaVar="USERNAME", usage="initial set of users to become members of the group")
    void addMember(Account.Id id) {
        this.initialMembers.add(id);
    }

    @Option(name="--group", aliases={"-g"}, metaVar="GROUP", usage="initial set of groups to be included in the group")
    void addGroup(AccountGroup.UUID id) {
        this.initialGroups.add(id);
    }

    @Override
    protected void run() throws BaseCommand.Failure, OrmException, IOException, ConfigInvalidException {
        try {
            GroupResource rsrc = this.createGroup();
            if (!this.initialMembers.isEmpty()) {
                this.addMembers(rsrc);
            }
            if (!this.initialGroups.isEmpty()) {
                this.addSubgroups(rsrc);
            }
        }
        catch (RestApiException e) {
            throw this.die(e);
        }
    }

    private GroupResource createGroup() throws RestApiException, OrmException, IOException, ConfigInvalidException {
        GroupInput input = new GroupInput();
        input.description = this.groupDescription;
        input.visibleToAll = this.visibleToAll;
        if (this.ownerGroupId != null) {
            input.ownerId = String.valueOf(this.ownerGroupId.get());
        }
        GroupInfo group = this.createGroupFactory.create(this.groupName).apply(TopLevelResource.INSTANCE, input);
        return this.groups.parse(TopLevelResource.INSTANCE, IdString.fromUrl(group.id));
    }

    private void addMembers(GroupResource rsrc) throws RestApiException, OrmException, IOException, ConfigInvalidException {
        AddMembers.Input input = AddMembers.Input.fromMembers(this.initialMembers.stream().map(Object::toString).collect(Collectors.toList()));
        this.addMembers.apply(rsrc, input);
    }

    private void addSubgroups(GroupResource rsrc) throws RestApiException, OrmException, IOException {
        AddSubgroups.Input input = AddSubgroups.Input.fromGroups(this.initialGroups.stream().map(AccountGroup.UUID::get).collect(Collectors.toList()));
        this.addSubgroups.apply(rsrc, input);
    }
}

