/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.UploadPackInitializer;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.validators.UploadValidationException;
import com.google.gerrit.server.git.validators.UploadValidators;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PostUploadHookChain;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.PreUploadHookChain;
import org.eclipse.jgit.transport.UploadPack;

final class Upload
extends AbstractGitCommand {
    @Inject
    private TransferConfig config;
    @Inject
    private VisibleRefFilter.Factory refFilterFactory;
    @Inject
    private DynamicSet<PreUploadHook> preUploadHooks;
    @Inject
    private DynamicSet<PostUploadHook> postUploadHooks;
    @Inject
    private DynamicSet<UploadPackInitializer> uploadPackInitializers;
    @Inject
    private UploadValidators.Factory uploadValidatorsFactory;
    @Inject
    private SshSession session;
    @Inject
    private PermissionBackend permissionBackend;

    Upload() {
    }

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        block6: {
            try {
                this.permissionBackend.user(this.projectControl.getUser()).project(this.projectControl.getProject().getNameKey()).check(ProjectPermission.RUN_UPLOAD_PACK);
            }
            catch (AuthException e) {
                throw new BaseCommand.Failure(1, "fatal: upload-pack not permitted on this server");
            }
            catch (PermissionBackendException e) {
                throw new BaseCommand.Failure(1, "fatal: unable to check permissions " + e);
            }
            UploadPack up = new UploadPack(this.repo);
            up.setAdvertiseRefsHook(this.refFilterFactory.create(this.projectControl.getProjectState(), this.repo));
            up.setPackConfig(this.config.getPackConfig());
            up.setTimeout(this.config.getTimeout());
            up.setPostUploadHook(PostUploadHookChain.newChain(Lists.newArrayList(this.postUploadHooks)));
            ArrayList<PreUploadHook> allPreUploadHooks = Lists.newArrayList(this.preUploadHooks);
            allPreUploadHooks.add(this.uploadValidatorsFactory.create(this.project, this.repo, this.session.getRemoteAddressAsString()));
            up.setPreUploadHook(PreUploadHookChain.newChain(allPreUploadHooks));
            for (UploadPackInitializer initializer : this.uploadPackInitializers) {
                initializer.init(this.projectControl.getProject().getNameKey(), up);
            }
            try {
                up.upload(this.in, this.out, this.err);
                this.session.setPeerAgent(up.getPeerUserAgent());
            }
            catch (UploadValidationException e) {
                if (e.isOutput()) break block6;
                up.sendMessage(e.getMessage());
            }
        }
    }
}

