/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprparse;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprparse.ExpressionParserConstants;
import com.google.template.soy.exprparse.ParseException;
import com.google.template.soy.exprparse.Token;
import com.google.template.soy.exprparse.Tokens;
import com.google.template.soy.exprparse.V1ExpressionErrors;

final class ParseErrors {
    private ParseErrors() {
    }

    static void reportExprParseException(ErrorReporter reporter, SourceLocation parentSourceLocation, ParseException e) {
        Token errorToken = e.currentToken;
        if (errorToken.next != null) {
            errorToken = errorToken.next;
        }
        SourceLocation errorLocation = Tokens.createSrcLoc(parentSourceLocation, errorToken);
        switch (errorToken.kind) {
            case 39: {
                reporter.report(errorLocation, V1ExpressionErrors.LEGACY_AND_ERROR, new Object[0]);
                return;
            }
            case 40: {
                reporter.report(errorLocation, V1ExpressionErrors.LEGACY_OR_ERROR, new Object[0]);
                return;
            }
            case 41: {
                reporter.report(errorLocation, V1ExpressionErrors.LEGACY_NOT_ERROR, new Object[0]);
                return;
            }
            case 42: {
                reporter.report(errorLocation, V1ExpressionErrors.LEGACY_DOUBLE_QUOTED_STRING, new Object[0]);
                return;
            }
        }
        ImmutableSet.Builder expectedTokenImages = ImmutableSet.builder();
        for (int[] expected : e.expectedTokenSequences) {
            expectedTokenImages.add(ParseErrors.getSoyFileParserTokenDisplayName(expected[0]));
        }
        reporter.report(errorLocation, SoyErrorKind.of("{0}"), BaseUtils.formatParseExceptionDetails(errorToken.image, ((ImmutableSet)expectedTokenImages.build()).asList()));
    }

    private static String getSoyFileParserTokenDisplayName(int tokenId) {
        switch (tokenId) {
            case 0: {
                return "eof";
            }
            case 4: 
            case 5: 
            case 6: {
                return "number";
            }
            case 7: {
                return "string";
            }
            case 35: {
                return "an identifier";
            }
            case 37: {
                return "variable";
            }
            case 43: {
                throw new AssertionError((Object)"we should never expect the unexpected token");
            }
        }
        return ExpressionParserConstants.tokenImage[tokenId];
    }
}

