/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.coredirectives.CoreDirectiveUtils;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesVisitor;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import javax.inject.Inject;

public class OptimizeBidiCodeGenVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final String BIDI_MARK_FN_NAME = "bidiMark";
    private static final String BIDI_START_EDGE_FN_NAME = "bidiStartEdge";
    private static final String BIDI_END_EDGE_FN_NAME = "bidiEndEdge";
    private BidiGlobalDir bidiGlobalDir;
    private IdGenerator nodeIdGen;
    boolean madeReplacement;

    @Inject
    public OptimizeBidiCodeGenVisitor(BidiGlobalDir bidiGlobalDir) {
        this.bidiGlobalDir = bidiGlobalDir;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        if (!this.bidiGlobalDir.isStaticValue()) {
            return;
        }
        this.nodeIdGen = node.getNodeIdGenerator();
        this.madeReplacement = false;
        this.visitChildren(node);
        if (this.madeReplacement) {
            new CombineConsecutiveRawTextNodesVisitor(node.getNodeIdGenerator()).exec(node);
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        String rawText;
        if (!node.couldHaveSyntaxVersionAtLeast(SyntaxVersion.V2_0)) {
            return;
        }
        ParentNode parent = node.getParent();
        if (parent instanceof SoyNode.MsgBlockNode) {
            return;
        }
        ExprNode expr = node.getExpr().getRoot();
        if (!(expr instanceof FunctionNode)) {
            return;
        }
        SoyFunction fn = ((FunctionNode)expr).getSoyFunction();
        if (fn == null) {
            return;
        }
        switch (fn.getName()) {
            case "bidiMark": {
                rawText = this.bidiGlobalDir.getStaticValue() < 0 ? "\\u200F" : "\\u200E";
                break;
            }
            case "bidiStartEdge": {
                rawText = this.bidiGlobalDir.getStaticValue() < 0 ? "right" : "left";
                break;
            }
            case "bidiEndEdge": {
                rawText = this.bidiGlobalDir.getStaticValue() < 0 ? "left" : "right";
                break;
            }
            default: {
                return;
            }
        }
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            if (CoreDirectiveUtils.isCoreDirective(directiveNode)) continue;
            return;
        }
        parent.replaceChild(node, new RawTextNode(this.nodeIdGen.genId(), rawText, node.getSourceLocation()));
        this.madeReplacement = true;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildrenAllowingConcurrentModification((SoyNode.ParentSoyNode)node);
        }
    }
}

