/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;

final class CheckTemplateVisibility
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind CALLEE_NOT_VISIBLE = SoyErrorKind.of("{0} has {1} access in {2}");
    private final ErrorReporter errorReporter;
    private final TemplateRegistry templateRegistry;

    CheckTemplateVisibility(TemplateRegistry templateRegistry, ErrorReporter errorReporter) {
        this.templateRegistry = templateRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        this.visitChildren(node);
        String calleeName = node.getCalleeName();
        TemplateBasicNode definition = this.templateRegistry.getBasicTemplate(calleeName);
        if (definition != null && !CheckTemplateVisibility.isVisible(node, definition)) {
            this.errorReporter.report(node.getSourceLocation(), CALLEE_NOT_VISIBLE, calleeName, definition.getVisibility().getAttributeValue(), definition.getParent().getFilePath());
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private static boolean isVisible(CallNode caller, TemplateNode callee) {
        return callee.getVisibility() != Visibility.PRIVATE || callee.getParent().equals(caller.getNearestAncestor(SoyFileNode.class));
    }
}

