/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;

public final class CombineConsecutiveRawTextNodesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final IdGenerator nodeIdGen;

    public CombineConsecutiveRawTextNodesVisitor(IdGenerator nodeIdGen) {
        this.nodeIdGen = nodeIdGen;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (!(node instanceof SoyNode.ParentSoyNode)) {
            return;
        }
        SoyNode.ParentSoyNode nodeAsParent = (SoyNode.ParentSoyNode)node;
        int rawTextSeqStart = -1;
        for (int i = 0; i < nodeAsParent.numChildren(); ++i) {
            SoyNode child = (SoyNode)nodeAsParent.getChild(i);
            if (child instanceof RawTextNode) {
                if (rawTextSeqStart == -1) {
                    rawTextSeqStart = i;
                }
                if (i != nodeAsParent.numChildren() - 1 && nodeAsParent.getChild(i + 1) instanceof RawTextNode) continue;
                if (rawTextSeqStart < i) {
                    SoyNode.ParentSoyNode typedParent = nodeAsParent;
                    this.combineRawTextNodes(typedParent, rawTextSeqStart, i + 1);
                    i = rawTextSeqStart;
                } else if (((RawTextNode)child).isEmpty()) {
                    nodeAsParent.removeChild(i);
                    --i;
                }
                rawTextSeqStart = -1;
                continue;
            }
            this.visit(child);
        }
    }

    private void combineRawTextNodes(SoyNode.ParentSoyNode<? super RawTextNode> parent, int start, int end) {
        int i;
        int newId = this.nodeIdGen.genId();
        RawTextNode newNode = (RawTextNode)parent.getChild(start);
        for (i = start + 1; i < end; ++i) {
            newNode = newNode.concat(newId, (RawTextNode)parent.getChild(i));
        }
        for (i = end - 1; i > start; --i) {
            parent.removeChild(i);
        }
        parent.replaceChild((RawTextNode)start, newNode);
    }
}

