/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprparse.SoyParsingContext;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class PrintNode
extends AbstractParentCommandNode<PrintDirectiveNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<PrintDirectiveNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    public static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private final boolean isImplicit;
    private final ExprRootNode expr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    @Nullable
    private HtmlContext htmlContext;

    private PrintNode(int id, boolean isImplicit, ExprRootNode expr, SourceLocation sourceLocation, @Nullable String userSuppliedPlaceholderName) {
        super(id, sourceLocation, "print", "");
        this.isImplicit = isImplicit;
        this.expr = Preconditions.checkNotNull(expr);
        this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
    }

    private PrintNode(PrintNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isImplicit = orig.isImplicit;
        this.expr = orig.expr.copy(copyState);
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.htmlContext = orig.htmlContext;
    }

    public HtmlContext getHtmlContext() {
        return Preconditions.checkNotNull(this.htmlContext, "Cannot access HtmlContext before HtmlTransformVisitor");
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.PRINT_NODE;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public String getExprText() {
        return this.expr.toSourceString();
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    @Override
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        if (this.expr == null) {
            return FALLBACK_BASE_PLACEHOLDER_NAME;
        }
        return MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(this.expr.getRoot(), FALLBACK_BASE_PLACEHOLDER_NAME);
    }

    @Override
    public Object genSamenessKey() {
        return this.getCommandText();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of(this.expr);
    }

    @Override
    public String getCommandText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expr.toSourceString());
        for (PrintDirectiveNode child : this.getChildren()) {
            sb.append(' ').append(child.toSourceString());
        }
        if (this.userSuppliedPlaceholderName != null) {
            sb.append(" phname=\"").append(this.userSuppliedPlaceholderName).append('\"');
        }
        return sb.toString();
    }

    @Override
    public String getTagString() {
        return this.buildTagStringHelper(false, this.isImplicit);
    }

    @Override
    public String toSourceString() {
        return this.getTagString();
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public PrintNode copy(CopyState copyState) {
        return new PrintNode(this, copyState);
    }

    public static final class Builder {
        private final int id;
        private final boolean isImplicit;
        private final SourceLocation sourceLocation;
        @Nullable
        private String exprText;
        @Nullable
        private ExprRootNode expr;
        @Nullable
        private String userSuppliedPlaceholderName;

        public Builder(int id, boolean isImplicit, SourceLocation sourceLocation) {
            this.id = id;
            this.isImplicit = isImplicit;
            this.sourceLocation = sourceLocation;
        }

        public Builder exprText(String exprText) {
            Preconditions.checkState(this.exprText == null);
            Preconditions.checkState(this.expr == null);
            this.exprText = exprText;
            return this;
        }

        public Builder exprRoot(ExprRootNode exprRoot) {
            Preconditions.checkState(this.exprText == null);
            Preconditions.checkState(this.expr == null);
            this.expr = exprRoot;
            return this;
        }

        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        public PrintNode build(SoyParsingContext context) {
            ExprRootNode exprRoot = this.getOrParseExpr(context);
            return new PrintNode(this.id, this.isImplicit, exprRoot, this.sourceLocation, this.userSuppliedPlaceholderName);
        }

        private ExprRootNode getOrParseExpr(SoyParsingContext context) {
            if (this.expr != null) {
                return this.expr;
            }
            Preconditions.checkNotNull(this.exprText);
            return new ExprRootNode(new ExpressionParser(this.exprText, this.sourceLocation, context).parseExpression());
        }
    }
}

