/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types.ast;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.types.ast.AutoValue_UnionTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.TypeNodeVisitor;

public abstract class UnionTypeNode
extends TypeNode {
    public static UnionTypeNode create(Iterable<TypeNode> candidates) {
        ImmutableList<TypeNode> candidateList = ImmutableList.copyOf(candidates);
        Preconditions.checkArgument(candidateList.size() > 1);
        return new AutoValue_UnionTypeNode(((TypeNode)candidateList.get(0)).sourceLocation().extend(Iterables.getLast(candidateList).sourceLocation()), candidateList);
    }

    UnionTypeNode() {
    }

    public abstract ImmutableList<TypeNode> candidates();

    @Override
    public String toString() {
        return Joiner.on("|").join(this.candidates());
    }

    @Override
    public <T> T accept(TypeNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

