/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.parboiled.support.Checks;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

public class RuleMethodInterpreter
extends BasicInterpreter {
    private final RuleMethod method;
    private final List<Edge> additionalEdges = new ArrayList<Edge>();

    public RuleMethodInterpreter(RuleMethod method) {
        this.method = method;
    }

    @Override
    public BasicValue newValue(Type type) {
        BasicValue basicValue = super.newValue(type);
        if (basicValue == BasicValue.REFERENCE_VALUE) {
            basicValue = new BasicValue(type);
        }
        return basicValue;
    }

    @Override
    public BasicValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        return this.createNode(insn, super.newOperation(insn), new BasicValue[0]);
    }

    @Override
    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        return this.createNode(insn, super.copyOperation(insn, value), value);
    }

    @Override
    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        return this.createNode(insn, super.unaryOperation(insn, null), value);
    }

    @Override
    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        return this.createNode(insn, super.binaryOperation(insn, null, null), value1, value2);
    }

    @Override
    public BasicValue ternaryOperation(AbstractInsnNode insn, BasicValue v1, BasicValue v2, BasicValue v3) throws AnalyzerException {
        this.additionalEdges.add(new Edge(insn, this.findArrayCreatorPredecessor(v1)));
        return this.createNode(insn, super.ternaryOperation(insn, null, null, null), v1, v2, v3);
    }

    public BasicValue naryOperation(AbstractInsnNode insn, List<? extends BasicValue> values) throws AnalyzerException {
        return this.createNode(insn, super.naryOperation(insn, null), values.toArray(new BasicValue[values.size()]));
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, BasicValue value, BasicValue expected) throws AnalyzerException {
        Preconditions.checkState(insn.getOpcode() == 176);
        Preconditions.checkState(RuleMethodInterpreter.unwrap(value).getType().equals(Types.RULE));
        Preconditions.checkState(RuleMethodInterpreter.unwrap(expected).getType().equals(Types.RULE));
        Preconditions.checkState(this.method.getReturnInstructionNode() == null);
        this.method.setReturnInstructionNode(this.createNode(insn, null, value));
    }

    private InstructionGraphNode createNode(AbstractInsnNode insn, BasicValue resultValue, BasicValue ... prevNodes) {
        return this.method.setGraphNode(insn, RuleMethodInterpreter.unwrap(resultValue), Arrays.asList(prevNodes));
    }

    @Override
    public BasicValue merge(BasicValue v, BasicValue w) {
        return v;
    }

    public void newControlFlowEdge(int instructionIndex, int successorIndex) {
        AbstractInsnNode fromInsn = this.method.instructions.get(instructionIndex);
        AbstractInsnNode toInsn = this.method.instructions.get(successorIndex);
        if (RuleMethodInterpreter.isLabelOrJump(fromInsn) || RuleMethodInterpreter.isLabelOrJump(toInsn)) {
            this.additionalEdges.add(new Edge(fromInsn, toInsn));
        }
    }

    private static boolean isLabelOrJump(AbstractInsnNode node) {
        return node.getType() == 8 || node.getType() == 7;
    }

    private AbstractInsnNode findArrayCreatorPredecessor(BasicValue value) {
        int opcode;
        String errorMessage = "Internal error during analysis of rule method '" + this.method.name + "', please report this error to" + " https://github.com/parboiled1/grappa/issues! Thank you!";
        Checks.ensure(value instanceof InstructionGraphNode, errorMessage);
        InstructionGraphNode node = (InstructionGraphNode)value;
        while ((opcode = node.getInstruction().getOpcode()) != 189 && opcode != 188 && opcode != 197) {
            Checks.ensure(node.getPredecessors().size() == 1, errorMessage);
            node = node.getPredecessors().get(0);
        }
        return node.getInstruction();
    }

    public void finish() {
        for (Edge edge : this.additionalEdges) {
            InstructionGraphNode succ;
            InstructionGraphNode node = this.getGraphNode(edge.from);
            if (node == null) {
                node = this.createNode(edge.from, null, new BasicValue[0]);
            }
            if ((succ = this.getGraphNode(edge.to)) == null) {
                succ = this.createNode(edge.to, null, new BasicValue[0]);
            }
            succ.addPredecessor(node);
        }
    }

    private InstructionGraphNode getGraphNode(AbstractInsnNode insn) {
        return this.method.getGraphNodes().get(this.method.instructions.indexOf(insn));
    }

    private static BasicValue unwrap(BasicValue resultValue) {
        return resultValue instanceof InstructionGraphNode ? ((InstructionGraphNode)resultValue).getResultValue() : resultValue;
    }

    private static final class Edge {
        private final AbstractInsnNode from;
        private final AbstractInsnNode to;

        private Edge(AbstractInsnNode from, AbstractInsnNode to) {
            this.from = from;
            this.to = to;
        }
    }
}

