/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.matchers.unicode;

import com.github.parboiled1.grappa.matchers.unicode.BmpRangeMatcher;
import com.github.parboiled1.grappa.matchers.unicode.CombinedUnicodeRangeMatcher;
import com.github.parboiled1.grappa.matchers.unicode.GenericSupplementaryRangeMatcher;
import com.github.parboiled1.grappa.matchers.unicode.SingleLeadSurrogateRangeMatcher;
import com.google.common.base.Preconditions;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchervisitors.MatcherVisitor;

public abstract class UnicodeRangeMatcher
extends CustomMatcher {
    private static final char[] MIN_SUPPLEMENTARY = Character.toChars(65536);

    public static UnicodeRangeMatcher forRange(int low, int high) {
        String label = String.format("U+%04X-U+%04X", low, high);
        char[] lowChars = Character.toChars(low);
        char[] highChars = Character.toChars(high);
        if (lowChars.length == 1) {
            if (highChars.length == 1) {
                return new BmpRangeMatcher(label, lowChars[0], highChars[0]);
            }
            CharRangeMatcher bmp = new CharRangeMatcher(lowChars[0], '\uffff');
            UnicodeRangeMatcher supplementary = UnicodeRangeMatcher.supplementaryRange(label, MIN_SUPPLEMENTARY, highChars);
            return new CombinedUnicodeRangeMatcher(label, bmp, supplementary);
        }
        return UnicodeRangeMatcher.supplementaryRange(label, lowChars, highChars);
    }

    protected UnicodeRangeMatcher(String label) {
        super(label);
    }

    private static UnicodeRangeMatcher supplementaryRange(String label, char[] lowChars, char[] highChars) {
        return lowChars[0] == highChars[0] ? new SingleLeadSurrogateRangeMatcher(label, lowChars[0], lowChars[1], highChars[1]) : new GenericSupplementaryRangeMatcher(label, lowChars, highChars);
    }

    @Override
    public <R> R accept(MatcherVisitor<R> visitor) {
        Preconditions.checkNotNull(visitor, "visitor");
        return visitor.visit(this);
    }
}

