/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.cache.Cache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.audit.HttpAuditEvent;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.httpd.AdvertisedObjectsCacheKey;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.UploadPackInitializer;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.receive.AsyncReceiveCommits;
import com.google.gerrit.server.git.validators.UploadValidators;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.resolver.AsIsFileService;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PostUploadHookChain;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.PreUploadHookChain;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.RepositoryResolver;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.eclipse.jgit.transport.resolver.UploadPackFactory;

@Singleton
public class GitOverHttpServlet
extends GitServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATT_CONTROL = ProjectControl.class.getName();
    private static final String ATT_ARC = AsyncReceiveCommits.class.getName();
    private static final String ID_CACHE = "adv_bases";
    public static final String URL_REGEX;

    @Inject
    GitOverHttpServlet(Resolver resolver, UploadFactory upload, UploadFilter uploadFilter, ReceivePackFactory<HttpServletRequest> receive, ReceiveFilter receiveFilter) {
        this.setRepositoryResolver(resolver);
        this.setAsIsFileService(AsIsFileService.DISABLED);
        this.setUploadPackFactory(upload);
        this.addUploadPackFilter(uploadFilter);
        this.setReceivePackFactory(receive);
        this.addReceivePackFilter(receiveFilter);
    }

    private static String extractWhat(HttpServletRequest request) {
        StringBuilder commandName = new StringBuilder(request.getRequestURL());
        if (request.getQueryString() != null) {
            commandName.append("?").append(request.getQueryString());
        }
        return commandName.toString();
    }

    private static ListMultimap<String, String> extractParameters(HttpServletRequest request) {
        ArrayListMultimap<String, String> multiMap = ArrayListMultimap.create();
        if (request.getQueryString() != null) {
            request.getParameterMap().forEach((k, v) -> {
                for (int i = 0; i < ((String[])v).length; ++i) {
                    multiMap.put((String)k, v[i]);
                }
            });
        }
        return multiMap;
    }

    static {
        StringBuilder url = new StringBuilder();
        url.append("^(?:/a)?(?:/p/|/)(.*/(?:info/refs");
        for (String name : GitSmartHttpTools.VALID_SERVICES) {
            url.append('|').append(name);
        }
        url.append("))$");
        URL_REGEX = url.toString();
    }

    static class ReceiveFilter
    implements Filter {
        private final Cache<AdvertisedObjectsCacheKey, Set<ObjectId>> cache;
        private final PermissionBackend permissionBackend;
        private final Provider<CurrentUser> userProvider;
        private final AuditService auditService;

        @Inject
        ReceiveFilter(@Named(value="adv_bases") Cache<AdvertisedObjectsCacheKey, Set<ObjectId>> cache, PermissionBackend permissionBackend, Provider<CurrentUser> userProvider, AuditService auditService) {
            this.cache = cache;
            this.permissionBackend = permissionBackend;
            this.userProvider = userProvider;
            this.auditService = auditService;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            boolean isGet = "GET".equalsIgnoreCase(((HttpServletRequest)request).getMethod());
            AsyncReceiveCommits arc = (AsyncReceiveCommits)request.getAttribute(ATT_ARC);
            ReceivePack rp = arc.getReceivePack();
            rp.getAdvertiseRefsHook().advertiseRefs(rp);
            ProjectControl pc = (ProjectControl)request.getAttribute(ATT_CONTROL);
            Project.NameKey projectName = pc.getProject().getNameKey();
            try {
                this.permissionBackend.user(pc.getUser()).project(pc.getProject().getNameKey()).check(ProjectPermission.RUN_RECEIVE_PACK);
            }
            catch (AuthException e) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "receive-pack not permitted on this server");
                return;
            }
            catch (PermissionBackendException e) {
                throw new RuntimeException(e);
            }
            finally {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.auditService.dispatch(new HttpAuditEvent(httpRequest.getSession().getId(), this.userProvider.get(), GitOverHttpServlet.extractWhat(httpRequest), TimeUtil.nowMs(), GitOverHttpServlet.extractParameters(httpRequest), httpRequest.getMethod(), httpRequest, httpResponse.getStatus(), httpResponse));
            }
            Capable s = arc.canUpload();
            if (s != Capable.OK) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "\n" + s.getMessage());
                return;
            }
            if (!rp.isCheckReferencedObjectsAreReachable()) {
                chain.doFilter(request, response);
                return;
            }
            if (!pc.getUser().isIdentifiedUser()) {
                chain.doFilter(request, response);
                return;
            }
            AdvertisedObjectsCacheKey cacheKey = AdvertisedObjectsCacheKey.create(pc.getUser().getAccountId(), projectName);
            if (isGet) {
                this.cache.invalidate(cacheKey);
            } else {
                Set<ObjectId> ids = this.cache.getIfPresent(cacheKey);
                if (ids != null) {
                    rp.getAdvertisedObjects().addAll(ids);
                    this.cache.invalidate(cacheKey);
                }
            }
            chain.doFilter(request, response);
            if (isGet) {
                this.cache.put(cacheKey, Collections.unmodifiableSet(new HashSet<ObjectId>(rp.getAdvertisedObjects())));
            }
        }

        @Override
        public void init(FilterConfig arg0) {
        }

        @Override
        public void destroy() {
        }
    }

    static class DisabledReceiveFactory
    implements ReceivePackFactory<HttpServletRequest> {
        DisabledReceiveFactory() {
        }

        @Override
        public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotEnabledException {
            throw new ServiceNotEnabledException();
        }
    }

    static class ReceiveFactory
    implements ReceivePackFactory<HttpServletRequest> {
        private final AsyncReceiveCommits.Factory factory;

        @Inject
        ReceiveFactory(AsyncReceiveCommits.Factory factory) {
            this.factory = factory;
        }

        @Override
        public ReceivePack create(HttpServletRequest req, Repository db) throws ServiceNotAuthorizedException {
            ProjectControl pc = (ProjectControl)req.getAttribute(ATT_CONTROL);
            if (!pc.getUser().isIdentifiedUser()) {
                throw new ServiceNotAuthorizedException();
            }
            AsyncReceiveCommits arc = this.factory.create(pc, db, null, ImmutableSetMultimap.of());
            ReceivePack rp = arc.getReceivePack();
            req.setAttribute(ATT_ARC, arc);
            return rp;
        }
    }

    static class UploadFilter
    implements Filter {
        private final VisibleRefFilter.Factory refFilterFactory;
        private final UploadValidators.Factory uploadValidatorsFactory;
        private final PermissionBackend permissionBackend;
        private final Provider<CurrentUser> userProvider;
        private final AuditService auditService;

        @Inject
        UploadFilter(VisibleRefFilter.Factory refFilterFactory, UploadValidators.Factory uploadValidatorsFactory, PermissionBackend permissionBackend, Provider<CurrentUser> userProvider, AuditService auditService) {
            this.refFilterFactory = refFilterFactory;
            this.uploadValidatorsFactory = uploadValidatorsFactory;
            this.permissionBackend = permissionBackend;
            this.userProvider = userProvider;
            this.auditService = auditService;
        }

        @Override
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain next) throws IOException, ServletException {
            Repository repo = ServletUtils.getRepository(request);
            ProjectControl pc = (ProjectControl)request.getAttribute(ATT_CONTROL);
            UploadPack up = (UploadPack)request.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                this.permissionBackend.user(pc.getUser()).project(pc.getProject().getNameKey()).check(ProjectPermission.RUN_UPLOAD_PACK);
            }
            catch (AuthException e) {
                GitSmartHttpTools.sendError((HttpServletRequest)request, (HttpServletResponse)response, 403, "upload-pack not permitted on this server");
                return;
            }
            catch (PermissionBackendException e) {
                throw new ServletException(e);
            }
            finally {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                this.auditService.dispatch(new HttpAuditEvent(httpRequest.getSession().getId(), this.userProvider.get(), GitOverHttpServlet.extractWhat(httpRequest), TimeUtil.nowMs(), GitOverHttpServlet.extractParameters(httpRequest), httpRequest.getMethod(), httpRequest, httpResponse.getStatus(), httpResponse));
            }
            UploadValidators uploadValidators = this.uploadValidatorsFactory.create(pc.getProject(), repo, request.getRemoteHost());
            up.setPreUploadHook(PreUploadHookChain.newChain(Lists.newArrayList(up.getPreUploadHook(), uploadValidators)));
            up.setAdvertiseRefsHook(this.refFilterFactory.create(pc.getProjectState(), repo));
            next.doFilter(request, response);
        }

        @Override
        public void init(FilterConfig config) {
        }

        @Override
        public void destroy() {
        }
    }

    static class UploadFactory
    implements UploadPackFactory<HttpServletRequest> {
        private final TransferConfig config;
        private final DynamicSet<PreUploadHook> preUploadHooks;
        private final DynamicSet<PostUploadHook> postUploadHooks;
        private final DynamicSet<UploadPackInitializer> uploadPackInitializers;

        @Inject
        UploadFactory(TransferConfig tc, DynamicSet<PreUploadHook> preUploadHooks, DynamicSet<PostUploadHook> postUploadHooks, DynamicSet<UploadPackInitializer> uploadPackInitializers) {
            this.config = tc;
            this.preUploadHooks = preUploadHooks;
            this.postUploadHooks = postUploadHooks;
            this.uploadPackInitializers = uploadPackInitializers;
        }

        @Override
        public UploadPack create(HttpServletRequest req, Repository repo) {
            UploadPack up = new UploadPack(repo);
            up.setPackConfig(this.config.getPackConfig());
            up.setTimeout(this.config.getTimeout());
            up.setPreUploadHook(PreUploadHookChain.newChain(Lists.newArrayList(this.preUploadHooks)));
            up.setPostUploadHook(PostUploadHookChain.newChain(Lists.newArrayList(this.postUploadHooks)));
            ProjectControl pc = (ProjectControl)req.getAttribute(ATT_CONTROL);
            for (UploadPackInitializer initializer : this.uploadPackInitializers) {
                initializer.init(pc.getProject().getNameKey(), up);
            }
            return up;
        }
    }

    static class Resolver
    implements RepositoryResolver<HttpServletRequest> {
        private final GitRepositoryManager manager;
        private final PermissionBackend permissionBackend;
        private final Provider<CurrentUser> userProvider;
        private final ProjectControl.GenericFactory projectControlFactory;

        @Inject
        Resolver(GitRepositoryManager manager, PermissionBackend permissionBackend, Provider<CurrentUser> userProvider, ProjectControl.GenericFactory projectControlFactory) {
            this.manager = manager;
            this.permissionBackend = permissionBackend;
            this.userProvider = userProvider;
            this.projectControlFactory = projectControlFactory;
        }

        @Override
        public Repository open(HttpServletRequest req, String projectName) throws RepositoryNotFoundException, ServiceNotAuthorizedException, ServiceNotEnabledException, ServiceMayNotContinueException {
            while (projectName.endsWith("/")) {
                projectName = projectName.substring(0, projectName.length() - 1);
            }
            if (projectName.endsWith(".git")) {
                projectName = projectName.substring(0, projectName.length() - 4);
                while (projectName.endsWith("/")) {
                    projectName = projectName.substring(0, projectName.length() - 1);
                }
            }
            CurrentUser user = this.userProvider.get();
            user.setAccessPath(AccessPath.GIT);
            try {
                ProjectControl pc;
                Project.NameKey nameKey = new Project.NameKey(projectName);
                try {
                    pc = this.projectControlFactory.controlFor(nameKey, user);
                }
                catch (NoSuchProjectException err) {
                    throw new RepositoryNotFoundException(projectName);
                }
                req.setAttribute(ATT_CONTROL, pc);
                try {
                    this.permissionBackend.user(user).project(nameKey).check(ProjectPermission.ACCESS);
                }
                catch (AuthException e) {
                    if (user instanceof AnonymousUser) {
                        throw new ServiceNotAuthorizedException();
                    }
                    throw new ServiceNotEnabledException(e.getMessage());
                }
                return this.manager.openRepository(nameKey);
            }
            catch (PermissionBackendException | IOException err) {
                throw new ServiceMayNotContinueException(projectName + " unavailable", err);
            }
        }
    }

    static class Module
    extends AbstractModule {
        private final boolean enableReceive;

        Module(boolean enableReceive) {
            this.enableReceive = enableReceive;
        }

        @Override
        protected void configure() {
            this.bind(Resolver.class);
            this.bind(UploadFactory.class);
            this.bind(UploadFilter.class);
            this.bind(new TypeLiteral<ReceivePackFactory<HttpServletRequest>>(){}).to(this.enableReceive ? ReceiveFactory.class : DisabledReceiveFactory.class);
            this.bind(ReceiveFilter.class);
            this.install(new CacheModule(){

                @Override
                protected void configure() {
                    this.cache(GitOverHttpServlet.ID_CACHE, AdvertisedObjectsCacheKey.class, new TypeLiteral<Set<ObjectId>>(){}).maximumWeight(4096L).expireAfterWrite(10L, TimeUnit.MINUTES);
                }
            });
        }
    }
}

