/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.server.ssh.SshInfo;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jcraft.jsch.HostKey;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class SshInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final SshInfo sshd;

    @Inject
    SshInfoServlet(SshInfo daemon) {
        this.sshd = daemon;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String out;
        List<HostKey> hostKeys = this.sshd.getHostKeys();
        if (!hostKeys.isEmpty()) {
            String host = hostKeys.get(0).getHost();
            String port = "22";
            if (host.contains(":")) {
                int p = host.lastIndexOf(58);
                port = host.substring(p + 1);
                host = host.substring(0, p);
            }
            if (host.equals("*")) {
                host = req.getServerName();
            } else if (host.startsWith("[") && host.endsWith("]")) {
                host = host.substring(1, host.length() - 1);
            }
            out = host + " " + port;
        } else {
            out = "NOT_AVAILABLE";
        }
        CacheHeaders.setNotCacheable(rsp);
        rsp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        rsp.setContentType("text/plain");
        try (PrintWriter w = rsp.getWriter();){
            w.write(out);
        }
    }
}

