/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.gerrit.index.QueryOptions;
import com.google.gerrit.index.Schema;
import com.google.gerrit.index.query.DataSource;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.lucene.AbstractLuceneIndex;
import com.google.gerrit.lucene.GerritIndexWriterConfig;
import com.google.gerrit.lucene.LuceneIndexModule;
import com.google.gerrit.lucene.LuceneVersionManager;
import com.google.gerrit.lucene.QueryBuilder;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.index.IndexUtils;
import com.google.gerrit.server.index.group.GroupField;
import com.google.gerrit.server.index.group.GroupIndex;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneGroupIndex
extends AbstractLuceneIndex<AccountGroup.UUID, InternalGroup>
implements GroupIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneGroupIndex.class);
    private static final String GROUPS = "groups";
    private static final String UUID_SORT_FIELD = LuceneGroupIndex.sortFieldName(GroupField.UUID);
    private final GerritIndexWriterConfig indexWriterConfig;
    private final QueryBuilder<InternalGroup> queryBuilder;
    private final Provider<GroupCache> groupCache;

    private static Term idTerm(InternalGroup group) {
        return LuceneGroupIndex.idTerm(group.getGroupUUID());
    }

    private static Term idTerm(AccountGroup.UUID uuid) {
        return QueryBuilder.stringTerm(GroupField.UUID.getName(), uuid.get());
    }

    private static Directory dir(Schema<?> schema, Config cfg, SitePaths sitePaths) throws IOException {
        if (LuceneIndexModule.isInMemoryTest(cfg)) {
            return new RAMDirectory();
        }
        Path indexDir = LuceneVersionManager.getDir(sitePaths, GROUPS, schema);
        return FSDirectory.open(indexDir);
    }

    @Inject
    LuceneGroupIndex(@GerritServerConfig Config cfg, SitePaths sitePaths, Provider<GroupCache> groupCache, @Assisted Schema<InternalGroup> schema) throws IOException {
        super(schema, sitePaths, LuceneGroupIndex.dir(schema, cfg, sitePaths), GROUPS, null, new GerritIndexWriterConfig(cfg, GROUPS), new SearcherFactory());
        this.groupCache = groupCache;
        this.indexWriterConfig = new GerritIndexWriterConfig(cfg, GROUPS);
        this.queryBuilder = new QueryBuilder<InternalGroup>(schema, this.indexWriterConfig.getAnalyzer());
    }

    @Override
    public void replace(InternalGroup group) throws IOException {
        try {
            this.replace(LuceneGroupIndex.idTerm(group), this.toDocument(group)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(AccountGroup.UUID key) throws IOException {
        try {
            this.delete(LuceneGroupIndex.idTerm(key)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public DataSource<InternalGroup> getSource(Predicate<InternalGroup> p, QueryOptions opts) throws QueryParseException {
        return new QuerySource(opts, this.queryBuilder.toQuery(p), new Sort(new SortField(UUID_SORT_FIELD, SortField.Type.STRING, false)));
    }

    private Optional<InternalGroup> toInternalGroup(Document doc) {
        AccountGroup.UUID uuid = new AccountGroup.UUID(doc.getField(GroupField.UUID.getName()).stringValue());
        return this.groupCache.get().get(uuid);
    }

    private class QuerySource
    implements DataSource<InternalGroup> {
        private final QueryOptions opts;
        private final Query query;
        private final Sort sort;

        private QuerySource(QueryOptions opts, Query query, Sort sort) {
            this.opts = opts;
            this.query = query;
            this.sort = sort;
        }

        @Override
        public int getCardinality() {
            return 10;
        }

        @Override
        public ResultSet<InternalGroup> read() throws OrmException {
            IndexSearcher searcher = null;
            try {
                searcher = LuceneGroupIndex.this.acquire();
                int realLimit = this.opts.start() + this.opts.limit();
                TopFieldDocs docs = searcher.search(this.query, realLimit, this.sort);
                ArrayList result = new ArrayList(docs.scoreDocs.length);
                for (int i = this.opts.start(); i < docs.scoreDocs.length; ++i) {
                    ScoreDoc sd = docs.scoreDocs[i];
                    Document doc = searcher.doc(sd.doc, IndexUtils.groupFields(this.opts));
                    Optional internalGroup = LuceneGroupIndex.this.toInternalGroup(doc);
                    internalGroup.ifPresent(result::add);
                }
                final List r = Collections.unmodifiableList(result);
                ResultSet<InternalGroup> resultSet = new ResultSet<InternalGroup>(){

                    @Override
                    public Iterator<InternalGroup> iterator() {
                        return r.iterator();
                    }

                    @Override
                    public List<InternalGroup> toList() {
                        return r;
                    }

                    @Override
                    public void close() {
                    }
                };
                return resultSet;
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
            finally {
                if (searcher != null) {
                    try {
                        LuceneGroupIndex.this.release(searcher);
                    }
                    catch (IOException e) {
                        log.warn("cannot release Lucene searcher", e);
                    }
                }
            }
        }
    }
}

