/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.dropwizard;

import com.codahale.metrics.Metric;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.metrics.dropwizard.DropWizardMetricMaker;
import com.google.gerrit.metrics.dropwizard.MetricJson;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

class ListMetrics
implements RestReadView<ConfigResource> {
    private final PermissionBackend permissionBackend;
    private final CurrentUser user;
    private final DropWizardMetricMaker metrics;
    @Option(name="--data-only", usage="return only values")
    boolean dataOnly;
    @Option(name="--prefix", aliases={"-p"}, metaVar="PREFIX", usage="match metric by exact match or prefix")
    List<String> query = new ArrayList<String>();

    @Inject
    ListMetrics(PermissionBackend permissionBackend, CurrentUser user, DropWizardMetricMaker metrics) {
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.metrics = metrics;
    }

    public Map<String, MetricJson> apply(ConfigResource resource) throws AuthException, PermissionBackendException {
        this.permissionBackend.user(this.user).check(GlobalPermission.VIEW_CACHES);
        TreeMap<String, MetricJson> out = new TreeMap<String, MetricJson>();
        ArrayList<String> prefixes = new ArrayList<String>(this.query.size());
        for (String q : this.query) {
            if (q.endsWith("/")) {
                prefixes.add(q);
                continue;
            }
            Metric m = this.metrics.getMetric(q);
            if (m == null) continue;
            out.put(q, this.toJson(q, m));
        }
        if (this.query.isEmpty() || !prefixes.isEmpty()) {
            for (String name : this.metrics.getMetricNames()) {
                if (!ListMetrics.include(prefixes, name)) continue;
                out.put(name, this.toJson(name, this.metrics.getMetric(name)));
            }
        }
        return out;
    }

    private MetricJson toJson(String q, Metric m) {
        return new MetricJson(m, this.metrics.getAnnotations(q), this.dataOnly);
    }

    private static boolean include(List<String> prefixes, String name) {
        if (prefixes.isEmpty()) {
            return true;
        }
        for (String p : prefixes) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return false;
    }
}

