/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Comment;
import com.google.gwtorm.client.Column;

public class CommentRange {
    @Column(id=1)
    protected int startLine;
    @Column(id=2)
    protected int startCharacter;
    @Column(id=3)
    protected int endLine;
    @Column(id=4)
    protected int endCharacter;

    protected CommentRange() {
    }

    public CommentRange(int sl, int sc, int el, int ec) {
        this.startLine = sl;
        this.startCharacter = sc;
        this.endLine = el;
        this.endCharacter = ec;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartCharacter() {
        return this.startCharacter;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndCharacter() {
        return this.endCharacter;
    }

    public void setStartLine(int sl) {
        this.startLine = sl;
    }

    public void setStartCharacter(int sc) {
        this.startCharacter = sc;
    }

    public void setEndLine(int el) {
        this.endLine = el;
    }

    public void setEndCharacter(int ec) {
        this.endCharacter = ec;
    }

    public Comment.Range asCommentRange() {
        return new Comment.Range(this.startLine, this.startCharacter, this.endLine, this.endCharacter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommentRange) {
            CommentRange other = (CommentRange)obj;
            return this.startLine == other.startLine && this.startCharacter == other.startCharacter && this.endLine == other.endLine && this.endCharacter == other.endCharacter;
        }
        return false;
    }

    public int hashCode() {
        int h = this.startLine;
        h = h * 31 + this.startCharacter;
        h = h * 31 + this.endLine;
        h = h * 31 + this.endCharacter;
        return h;
    }

    public String toString() {
        return "Range[startLine=" + this.startLine + ", startCharacter=" + this.startCharacter + ", endLine=" + this.endLine + ", endCharacter=" + this.endCharacter + "]";
    }
}

