/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;

public final class PatchSetApproval {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected short value;
    @Column(id=3)
    protected Timestamp granted;
    @Column(id=6, notNull=false)
    protected String tag;
    @Column(id=7, notNull=false)
    protected Account.Id realAccountId;
    @Column(id=8)
    protected boolean postSubmit;

    protected PatchSetApproval() {
    }

    public PatchSetApproval(Key k, short v, Date ts) {
        this.key = k;
        this.setValue(v);
        this.setGranted(ts);
    }

    public PatchSetApproval(PatchSet.Id psId, PatchSetApproval src) {
        this.key = new Key(psId, src.getAccountId(), src.getLabelId());
        this.value = src.getValue();
        this.granted = src.granted;
        this.realAccountId = src.realAccountId;
        this.tag = src.tag;
        this.postSubmit = src.postSubmit;
    }

    public PatchSetApproval(PatchSetApproval src) {
        this(src.getPatchSetId(), src);
    }

    public Key getKey() {
        return this.key;
    }

    public PatchSet.Id getPatchSetId() {
        return this.key.patchSetId;
    }

    public Account.Id getAccountId() {
        return this.key.accountId;
    }

    public Account.Id getRealAccountId() {
        return this.realAccountId != null ? this.realAccountId : this.getAccountId();
    }

    public void setRealAccountId(Account.Id id) {
        this.realAccountId = Objects.equals(this.getAccountId(), id) ? null : id;
    }

    public LabelId getLabelId() {
        return this.key.categoryId;
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short v) {
        this.value = v;
    }

    public Timestamp getGranted() {
        return this.granted;
    }

    public void setGranted(Date when) {
        this.granted = when instanceof Timestamp ? (Timestamp)when : new Timestamp(when.getTime());
    }

    public void setTag(String t) {
        this.tag = t;
    }

    public String getLabel() {
        return this.getLabelId().get();
    }

    public boolean isLegacySubmit() {
        return "SUBM".equals(this.getLabel());
    }

    public String getTag() {
        return this.tag;
    }

    public void setPostSubmit(boolean postSubmit) {
        this.postSubmit = postSubmit;
    }

    public boolean isPostSubmit() {
        return this.postSubmit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.key).append(": ").append(this.value).append(",tag:").append(this.tag).append(",realAccountId:").append(this.realAccountId);
        if (this.postSubmit) {
            sb.append(",postSubmit");
        }
        return sb.append(']').toString();
    }

    public boolean equals(Object o) {
        if (o instanceof PatchSetApproval) {
            PatchSetApproval p = (PatchSetApproval)o;
            return Objects.equals(this.key, p.key) && Objects.equals(this.value, p.value) && Objects.equals(this.granted, p.granted) && Objects.equals(this.tag, p.tag) && Objects.equals(this.realAccountId, p.realAccountId) && this.postSubmit == p.postSubmit;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.granted, this.tag);
    }

    public static class Key
    extends CompoundKey<PatchSet.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, name="--NONE--")
        protected PatchSet.Id patchSetId;
        @Column(id=2)
        protected Account.Id accountId;
        @Column(id=3)
        protected LabelId categoryId;

        protected Key() {
            this.patchSetId = new PatchSet.Id();
            this.accountId = new Account.Id();
            this.categoryId = new LabelId();
        }

        public Key(PatchSet.Id ps, Account.Id a, LabelId c) {
            this.patchSetId = ps;
            this.accountId = a;
            this.categoryId = c;
        }

        @Override
        public PatchSet.Id getParentKey() {
            return this.patchSetId;
        }

        public Account.Id getAccountId() {
            return this.accountId;
        }

        public LabelId getLabelId() {
            return this.categoryId;
        }

        @Override
        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.accountId, this.categoryId};
        }
    }
}

