/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;

public class RefNames {
    public static final String HEAD = "HEAD";
    public static final String REFS = "refs/";
    public static final String REFS_HEADS = "refs/heads/";
    public static final String REFS_TAGS = "refs/tags/";
    public static final String REFS_CHANGES = "refs/changes/";
    public static final String REFS_META = "refs/meta/";
    public static final String REFS_REJECT_COMMITS = "refs/meta/reject-commits";
    public static final String REFS_CONFIG = "refs/meta/config";
    public static final String REFS_EXTERNAL_IDS = "refs/meta/external-ids";
    public static final String REFS_USERS_SELF = "refs/users/self";
    public static final String REFS_USERS_DEFAULT = "refs/users/default";
    public static final String REFS_DASHBOARDS = "refs/meta/dashboards/";
    public static final String REFS_SEQUENCES = "refs/sequences/";
    public static final String REFS_CACHE_AUTOMERGE = "refs/cache-automerge/";
    public static final String META_SUFFIX = "/meta";
    public static final String ROBOT_COMMENTS_SUFFIX = "/robot-comments";
    public static final String EDIT_PREFIX = "edit-";
    public static final String REFS_USERS = "refs/users/";
    public static final String REFS_DRAFT_COMMENTS = "refs/draft-comments/";
    public static final String REFS_STARRED_CHANGES = "refs/starred-changes/";

    public static String fullName(String ref) {
        return ref.startsWith(REFS) || ref.equals(HEAD) ? ref : REFS_HEADS + ref;
    }

    public static final String shortName(String ref) {
        if (ref.startsWith(REFS_HEADS)) {
            return ref.substring(REFS_HEADS.length());
        }
        if (ref.startsWith(REFS_TAGS)) {
            return ref.substring(REFS_TAGS.length());
        }
        return ref;
    }

    public static boolean isGerritRef(String ref) {
        return ref.startsWith(REFS_CHANGES) || ref.startsWith(REFS_EXTERNAL_IDS) || ref.startsWith(REFS_CACHE_AUTOMERGE) || ref.startsWith(REFS_DRAFT_COMMENTS) || ref.startsWith(REFS_SEQUENCES) || ref.startsWith(REFS_USERS) || ref.startsWith(REFS_STARRED_CHANGES) || ref.startsWith(REFS_REJECT_COMMITS);
    }

    public static String changeMetaRef(Change.Id id) {
        StringBuilder r = RefNames.newStringBuilder().append(REFS_CHANGES);
        return RefNames.shard(id.get(), r).append(META_SUFFIX).toString();
    }

    public static String patchSetRef(PatchSet.Id id) {
        StringBuilder r = RefNames.newStringBuilder().append(REFS_CHANGES);
        return RefNames.shard(id.changeId.get(), r).append('/').append(id.get()).toString();
    }

    public static String robotCommentsRef(Change.Id id) {
        StringBuilder r = RefNames.newStringBuilder().append(REFS_CHANGES);
        return RefNames.shard(id.get(), r).append(ROBOT_COMMENTS_SUFFIX).toString();
    }

    public static boolean isNoteDbMetaRef(String ref) {
        if (ref.startsWith(REFS_CHANGES) && (ref.endsWith(META_SUFFIX) || ref.endsWith(ROBOT_COMMENTS_SUFFIX))) {
            return true;
        }
        return ref.startsWith(REFS_DRAFT_COMMENTS) || ref.startsWith(REFS_STARRED_CHANGES);
    }

    public static String refsUsers(Account.Id accountId) {
        StringBuilder r = RefNames.newStringBuilder().append(REFS_USERS);
        return RefNames.shard(accountId.get(), r).toString();
    }

    public static String refsDraftComments(Change.Id changeId, Account.Id accountId) {
        return RefNames.buildRefsPrefix(REFS_DRAFT_COMMENTS, changeId.get()).append(accountId.get()).toString();
    }

    public static String refsDraftCommentsPrefix(Change.Id changeId) {
        return RefNames.buildRefsPrefix(REFS_DRAFT_COMMENTS, changeId.get()).toString();
    }

    public static String refsStarredChanges(Change.Id changeId, Account.Id accountId) {
        return RefNames.buildRefsPrefix(REFS_STARRED_CHANGES, changeId.get()).append(accountId.get()).toString();
    }

    public static String refsStarredChangesPrefix(Change.Id changeId) {
        return RefNames.buildRefsPrefix(REFS_STARRED_CHANGES, changeId.get()).toString();
    }

    private static StringBuilder buildRefsPrefix(String prefix, int id) {
        StringBuilder r = RefNames.newStringBuilder().append(prefix);
        return RefNames.shard(id, r).append('/');
    }

    public static String refsCacheAutomerge(String hash) {
        return REFS_CACHE_AUTOMERGE + hash.substring(0, 2) + '/' + hash.substring(2);
    }

    public static String shard(int id) {
        if (id < 0) {
            return null;
        }
        return RefNames.shard(id, RefNames.newStringBuilder()).toString();
    }

    private static StringBuilder shard(int id, StringBuilder sb) {
        int n = id % 100;
        if (n < 10) {
            sb.append('0');
        }
        sb.append(n);
        sb.append('/');
        sb.append(id);
        return sb;
    }

    public static String refsEdit(Account.Id accountId, Change.Id changeId, PatchSet.Id psId) {
        return RefNames.refsEditPrefix(accountId, changeId) + psId.get();
    }

    public static String refsEditPrefix(Account.Id accountId, Change.Id changeId) {
        return RefNames.refsEditPrefix(accountId) + changeId.get() + '/';
    }

    public static String refsEditPrefix(Account.Id accountId) {
        return RefNames.refsUsers(accountId) + '/' + EDIT_PREFIX;
    }

    public static boolean isRefsEdit(String ref) {
        return ref != null && ref.startsWith(REFS_USERS) && ref.contains(EDIT_PREFIX);
    }

    public static boolean isRefsUsers(String ref) {
        return ref.startsWith(REFS_USERS);
    }

    static Integer parseShardedRefPart(String name) {
        int ie;
        int le;
        if (name == null) {
            return null;
        }
        String[] parts = name.split("/");
        int n = parts.length;
        if (n < 2) {
            return null;
        }
        for (le = 0; le < parts[0].length(); ++le) {
            if (Character.isDigit(parts[0].charAt(le))) continue;
            return null;
        }
        if (le != 2) {
            return null;
        }
        for (ie = 0; ie < parts[1].length(); ++ie) {
            if (Character.isDigit(parts[1].charAt(ie))) continue;
            if (ie != 0) break;
            return null;
        }
        int shard = Integer.parseInt(parts[0]);
        int id = Integer.parseInt(parts[1].substring(0, ie));
        if (id % 100 != shard) {
            return null;
        }
        return id;
    }

    static String skipShardedRefPart(String name) {
        int ie;
        int le;
        if (name == null) {
            return null;
        }
        String[] parts = name.split("/");
        int n = parts.length;
        if (n < 2) {
            return null;
        }
        for (le = 0; le < parts[0].length(); ++le) {
            if (Character.isDigit(parts[0].charAt(le))) continue;
            return null;
        }
        if (le != 2) {
            return null;
        }
        for (ie = 0; ie < parts[1].length(); ++ie) {
            if (Character.isDigit(parts[1].charAt(ie))) continue;
            if (ie != 0) break;
            return null;
        }
        int shard = Integer.parseInt(parts[0]);
        int id = Integer.parseInt(parts[1].substring(0, ie));
        if (id % 100 != shard) {
            return null;
        }
        return name.substring(3 + ie);
    }

    static Integer parseAfterShardedRefPart(String name) {
        int ie;
        String rest = RefNames.skipShardedRefPart(name);
        if (rest == null || !rest.startsWith("/")) {
            return null;
        }
        rest = rest.substring(1);
        for (ie = 0; ie < rest.length() && Character.isDigit(rest.charAt(ie)); ++ie) {
        }
        if (ie == 0) {
            return null;
        }
        return Integer.parseInt(rest.substring(0, ie));
    }

    static Integer parseRefSuffix(String name) {
        char c;
        int i;
        if (name == null) {
            return null;
        }
        for (i = name.length(); i > 0 && (c = name.charAt(i - 1)) != '/'; --i) {
            if (Character.isDigit(c)) continue;
            return null;
        }
        if (i == 0) {
            return null;
        }
        return Integer.valueOf(name.substring(i, name.length()));
    }

    private static StringBuilder newStringBuilder() {
        return new StringBuilder(64);
    }

    private RefNames() {
    }
}

