/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteExternalIds
implements RestModifyView<AccountResource, List<String>> {
    private final PermissionBackend permissionBackend;
    private final AccountManager accountManager;
    private final ExternalIds externalIds;
    private final Provider<CurrentUser> self;

    @Inject
    DeleteExternalIds(PermissionBackend permissionBackend, AccountManager accountManager, ExternalIds externalIds, Provider<CurrentUser> self) {
        this.permissionBackend = permissionBackend;
        this.accountManager = accountManager;
        this.externalIds = externalIds;
        this.self = self;
    }

    public Response<?> apply(AccountResource resource, List<String> extIds) throws RestApiException, IOException, OrmException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(resource.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ACCESS_DATABASE);
        }
        if (extIds == null || extIds.size() == 0) {
            throw new BadRequestException("external IDs are required");
        }
        Map<ExternalId.Key, ExternalId> externalIdMap = this.externalIds.byAccount(resource.getUser().getAccountId()).stream().collect(Collectors.toMap(i -> i.key(), i -> i));
        ArrayList<ExternalId> toDelete = new ArrayList<ExternalId>();
        ExternalId.Key last = resource.getUser().getLastLoginExternalIdKey();
        for (String externalIdStr : extIds) {
            ExternalId id = externalIdMap.get(ExternalId.Key.parse(externalIdStr));
            if (id == null) {
                throw new UnprocessableEntityException(String.format("External id %s does not exist", externalIdStr));
            }
            if (!(id.isScheme("username") || last != null && last.get().equals(id.key().get()))) {
                toDelete.add(id);
                continue;
            }
            throw new ResourceConflictException(String.format("External id %s cannot be deleted", externalIdStr));
        }
        try {
            this.accountManager.unlink(resource.getUser().getAccountId(), toDelete.stream().map(e -> e.key()).collect(Collectors.toSet()));
        }
        catch (AccountException e2) {
            throw new ResourceConflictException(e2.getMessage());
        }
        return Response.none();
    }
}

