/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAuthorizedKeys;
import com.google.gerrit.server.mail.send.DeleteKeySender;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.ssh.SshKeyCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeleteSshKey
implements RestModifyView<AccountResource.SshKey, Input> {
    private static final Logger log = LoggerFactory.getLogger(DeleteSshKey.class);
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final VersionedAuthorizedKeys.Accessor authorizedKeys;
    private final SshKeyCache sshKeyCache;
    private final DeleteKeySender.Factory deleteKeySenderFactory;

    @Inject
    DeleteSshKey(Provider<CurrentUser> self, PermissionBackend permissionBackend, VersionedAuthorizedKeys.Accessor authorizedKeys, SshKeyCache sshKeyCache, DeleteKeySender.Factory deleteKeySenderFactory) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.authorizedKeys = authorizedKeys;
        this.sshKeyCache = sshKeyCache;
        this.deleteKeySenderFactory = deleteKeySenderFactory;
    }

    public Response<?> apply(AccountResource.SshKey rsrc, Input input) throws AuthException, OrmException, RepositoryNotFoundException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        IdentifiedUser user = rsrc.getUser();
        this.authorizedKeys.deleteKey(user.getAccountId(), rsrc.getSshKey().getKey().get());
        try {
            this.deleteKeySenderFactory.create(user, rsrc.getSshKey()).send();
        }
        catch (EmailException e) {
            log.error("Cannot send SSH key deletion message to {}", (Object)user.getAccount().getPreferredEmail(), (Object)e);
        }
        this.sshKeyCache.evict(user.getUserName());
        return Response.none();
    }

    public static class Input {
    }
}

