/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Streams;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class Emails {
    private final ExternalIds externalIds;
    private final Provider<InternalAccountQuery> queryProvider;

    @Inject
    public Emails(ExternalIds externalIds, Provider<InternalAccountQuery> queryProvider) {
        this.externalIds = externalIds;
        this.queryProvider = queryProvider;
    }

    public ImmutableSet<Account.Id> getAccountFor(String email) throws IOException, OrmException {
        return Streams.concat(this.externalIds.byEmail(email).stream().map(e -> e.accountId()), this.queryProvider.get().byPreferredEmail(email).stream().map(a -> a.getAccount().getId())).collect(ImmutableSet.toImmutableSet());
    }

    public ImmutableSetMultimap<String, Account.Id> getAccountsFor(String ... emails) throws IOException, OrmException {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        this.externalIds.byEmails(emails).entries().stream().forEach(e -> builder.put((String)e.getKey(), ((ExternalId)e.getValue()).accountId()));
        this.queryProvider.get().byPreferredEmail(emails).entries().stream().forEach(e -> builder.put((String)e.getKey(), ((AccountState)e.getValue()).getAccount().getId()));
        return builder.build();
    }
}

