/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.avatar.AvatarProvider;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.kohsuke.args4j.Option;

public class GetAvatar
implements RestReadView<AccountResource> {
    private final DynamicItem<AvatarProvider> avatarProvider;
    private int size;

    @Option(name="--size", aliases={"-s"}, usage="recommended size in pixels, height and width")
    public void setSize(int s) {
        this.size = s;
    }

    @Inject
    GetAvatar(DynamicItem<AvatarProvider> avatarProvider) {
        this.avatarProvider = avatarProvider;
    }

    public Response.Redirect apply(AccountResource rsrc) throws ResourceNotFoundException {
        AvatarProvider impl = this.avatarProvider.get();
        if (impl == null) {
            throw new ResourceNotFoundException().caching(CacheControl.PUBLIC(1L, TimeUnit.DAYS));
        }
        String url = impl.getUrl(rsrc.getUser(), this.size);
        if (Strings.isNullOrEmpty(url)) {
            throw new ResourceNotFoundException().caching(CacheControl.PUBLIC(1L, TimeUnit.HOURS));
        }
        return Response.redirect(url);
    }
}

