/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.DeleteCommentInput;
import com.google.gerrit.extensions.api.changes.DraftApi;
import com.google.gerrit.extensions.api.changes.DraftInput;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.DeleteDraftComment;
import com.google.gerrit.server.change.DraftCommentResource;
import com.google.gerrit.server.change.GetDraftComment;
import com.google.gerrit.server.change.PutDraftComment;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

class DraftApiImpl
implements DraftApi {
    private final DeleteDraftComment deleteDraft;
    private final GetDraftComment getDraft;
    private final PutDraftComment putDraft;
    private final DraftCommentResource draft;

    @Inject
    DraftApiImpl(DeleteDraftComment deleteDraft, GetDraftComment getDraft, PutDraftComment putDraft, @Assisted DraftCommentResource draft) {
        this.deleteDraft = deleteDraft;
        this.getDraft = getDraft;
        this.putDraft = putDraft;
        this.draft = draft;
    }

    @Override
    public CommentInfo get() throws RestApiException {
        try {
            return this.getDraft.apply(this.draft);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve draft", e);
        }
    }

    @Override
    public CommentInfo update(DraftInput in) throws RestApiException {
        try {
            return (CommentInfo)((Response)this.putDraft.apply(this.draft, in)).value();
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot update draft", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteDraft.apply(this.draft, null);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete draft", e);
        }
    }

    @Override
    public CommentInfo delete(DeleteCommentInput input) {
        throw new NotImplementedException();
    }

    static interface Factory {
        public DraftApiImpl create(DraftCommentResource var1);
    }
}

