/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.api.projects.DashboardApi;
import com.google.gerrit.extensions.api.projects.DashboardInfo;
import com.google.gerrit.extensions.common.SetDashboardInput;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.DashboardResource;
import com.google.gerrit.server.project.DashboardsCollection;
import com.google.gerrit.server.project.GetDashboard;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.SetDashboard;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class DashboardApiImpl
implements DashboardApi {
    private final DashboardsCollection dashboards;
    private final Provider<GetDashboard> get;
    private final SetDashboard set;
    private final ProjectResource project;
    private final String id;

    @Inject
    DashboardApiImpl(DashboardsCollection dashboards, Provider<GetDashboard> get, SetDashboard set, @Assisted ProjectResource project, @Assisted @Nullable String id) {
        this.dashboards = dashboards;
        this.get = get;
        this.set = set;
        this.project = project;
        this.id = id;
    }

    @Override
    public DashboardInfo get() throws RestApiException {
        return this.get(false);
    }

    @Override
    public DashboardInfo get(boolean inherited) throws RestApiException {
        try {
            return this.get.get().setInherited(inherited).apply(this.resource());
        }
        catch (PermissionBackendException | IOException | ConfigInvalidException e) {
            throw ApiUtil.asRestApiException("Cannot read dashboard", e);
        }
    }

    @Override
    public void setDefault() throws RestApiException {
        SetDashboardInput input = new SetDashboardInput();
        input.id = this.id;
        try {
            this.set.apply(DashboardResource.projectDefault(this.project.getControl()), input);
        }
        catch (Exception e) {
            String msg = String.format("Cannot %s default dashboard", this.id != null ? "set" : "remove");
            throw ApiUtil.asRestApiException(msg, e);
        }
    }

    private DashboardResource resource() throws ResourceNotFoundException, IOException, ConfigInvalidException, PermissionBackendException {
        return this.dashboards.parse(this.project, IdString.fromDecoded(this.id));
    }

    static interface Factory {
        public DashboardApiImpl create(ProjectResource var1, String var2);
    }
}

