/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.eclipse.jgit.lib.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeResource
implements RestResource,
RestResource.HasETag {
    private static final Logger log = LoggerFactory.getLogger(ChangeResource.class);
    public static final int JSON_FORMAT_VERSION = 1;
    public static final TypeLiteral<RestView<ChangeResource>> CHANGE_KIND = new TypeLiteral<RestView<ChangeResource>>(){};
    private static final String ZERO_ID_STRING = ObjectId.zeroId().name();
    private final Provider<ReviewDb> db;
    private final AccountCache accountCache;
    private final ApprovalsUtil approvalUtil;
    private final PatchSetUtil patchSetUtil;
    private final PermissionBackend permissionBackend;
    private final StarredChangesUtil starredChangesUtil;
    private final ProjectCache projectCache;
    private final ChangeNotes notes;
    private final CurrentUser user;

    @Inject
    ChangeResource(Provider<ReviewDb> db, AccountCache accountCache, ApprovalsUtil approvalUtil, PatchSetUtil patchSetUtil, PermissionBackend permissionBackend, StarredChangesUtil starredChangesUtil, ProjectCache projectCache, @Assisted ChangeNotes notes, @Assisted CurrentUser user) {
        this.db = db;
        this.accountCache = accountCache;
        this.approvalUtil = approvalUtil;
        this.patchSetUtil = patchSetUtil;
        this.permissionBackend = permissionBackend;
        this.starredChangesUtil = starredChangesUtil;
        this.projectCache = projectCache;
        this.notes = notes;
        this.user = user;
    }

    public PermissionBackend.ForChange permissions() {
        return this.permissionBackend.user(this.user).change(this.notes);
    }

    public CurrentUser getUser() {
        return this.user;
    }

    public Change.Id getId() {
        return this.notes.getChangeId();
    }

    public boolean isUserOwner() {
        Account.Id owner = this.getChange().getOwner();
        return this.user.isIdentifiedUser() && this.user.asIdentifiedUser().getAccountId().equals(owner);
    }

    public Change getChange() {
        return this.notes.getChange();
    }

    public Project.NameKey getProject() {
        return this.getChange().getProject();
    }

    public ChangeNotes getNotes() {
        return this.notes;
    }

    public void prepareETag(Hasher h, CurrentUser user) {
        Iterable<ProjectState> projectStateTree;
        ObjectId noteId;
        h.putInt(1).putLong(this.getChange().getLastUpdatedOn().getTime()).putInt(this.getChange().getRowVersion()).putInt(user.isIdentifiedUser() ? user.getAccountId().get() : 0);
        if (user.isIdentifiedUser()) {
            for (AccountGroup.UUID uuid : user.getEffectiveGroups().getKnownGroups()) {
                h.putBytes(uuid.get().getBytes(StandardCharsets.UTF_8));
            }
        }
        byte[] buf = new byte[20];
        HashSet<Account.Id> accounts = new HashSet<Account.Id>();
        accounts.add(this.getChange().getOwner());
        if (this.getChange().getAssignee() != null) {
            accounts.add(this.getChange().getAssignee());
        }
        try {
            this.patchSetUtil.byChange(this.db.get(), this.notes).stream().map(ps -> ps.getUploader()).forEach(accounts::add);
            accounts.addAll(this.approvalUtil.getReviewers(this.db.get(), this.notes).all());
        }
        catch (OrmException ormException) {
            // empty catch block
        }
        accounts.stream().forEach(a -> this.hashAccount(h, this.accountCache.get((Account.Id)a), buf));
        try {
            noteId = this.notes.loadRevision();
        }
        catch (OrmException e) {
            noteId = null;
        }
        this.hashObjectId(h, noteId, buf);
        try {
            projectStateTree = this.projectCache.checkedGet(this.getProject()).tree();
        }
        catch (IOException e) {
            log.error("could not load project {} while computing etag", (Object)this.getProject());
            projectStateTree = ImmutableList.of();
        }
        for (ProjectState p : projectStateTree) {
            this.hashObjectId(h, p.getConfig().getRevision(), buf);
        }
    }

    @Override
    public String getETag() {
        Hasher h = Hashing.murmur3_128().newHasher();
        if (this.user.isIdentifiedUser()) {
            h.putString(this.starredChangesUtil.getObjectId(this.user.getAccountId(), this.getId()).name(), StandardCharsets.UTF_8);
        }
        this.prepareETag(h, this.user);
        return h.hash().toString();
    }

    private void hashObjectId(Hasher h, ObjectId id, byte[] buf) {
        MoreObjects.firstNonNull(id, ObjectId.zeroId()).copyRawTo(buf, 0);
        h.putBytes(buf);
    }

    private void hashAccount(Hasher h, AccountState accountState, byte[] buf) {
        h.putString(MoreObjects.firstNonNull(accountState.getAccount().getMetaId(), ZERO_ID_STRING), StandardCharsets.UTF_8);
        accountState.getExternalIds().stream().forEach(e -> this.hashObjectId(h, e.blobId(), buf));
    }

    public static interface Factory {
        public ChangeResource create(ChangeNotes var1, CurrentUser var2);
    }
}

