/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.FileContentUtil;
import com.google.gerrit.server.change.FileResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.args4j.Option;

public class DownloadContent
implements RestReadView<FileResource> {
    private final FileContentUtil fileContentUtil;
    private final ProjectCache projectCache;
    @Option(name="--parent")
    private Integer parent;

    @Inject
    DownloadContent(FileContentUtil fileContentUtil, ProjectCache projectCache) {
        this.fileContentUtil = fileContentUtil;
        this.projectCache = projectCache;
    }

    public BinaryResult apply(FileResource rsrc) throws ResourceNotFoundException, IOException, NoSuchChangeException, OrmException {
        String path = rsrc.getPatchKey().get();
        RevisionResource rev = rsrc.getRevision();
        ObjectId revstr = ObjectId.fromString(rev.getPatchSet().getRevision().get());
        return this.fileContentUtil.downloadContent(this.projectCache.checkedGet(rev.getProject()), revstr, path, this.parent);
    }
}

