/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.ListChangeDrafts;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class ListChangeComments
extends ListChangeDrafts {
    @Inject
    ListChangeComments(Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        super(db, changeDataFactory, commentJson, commentsUtil);
    }

    @Override
    protected Iterable<Comment> listComments(ChangeResource rsrc) throws OrmException {
        ChangeData cd = this.changeDataFactory.create((ReviewDb)this.db.get(), rsrc.getNotes());
        return this.commentsUtil.publishedByChange((ReviewDb)this.db.get(), cd.notes());
    }

    @Override
    protected boolean includeAuthorInfo() {
        return true;
    }

    @Override
    public boolean requireAuthentication() {
        return false;
    }
}

