/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.ChangeReverted;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.mail.send.RevertedSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ContributorAgreementsChecker;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Revert
extends RetryingRestModifyView<ChangeResource, RevertInput, ChangeInfo>
implements UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Revert.class);
    private final Provider<ReviewDb> db;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager repoManager;
    private final ChangeInserter.Factory changeInserterFactory;
    private final ChangeMessagesUtil cmUtil;
    private final Sequences seq;
    private final PatchSetUtil psUtil;
    private final RevertedSender.Factory revertedSenderFactory;
    private final ChangeJson.Factory json;
    private final PersonIdent serverIdent;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeReverted changeReverted;
    private final ContributorAgreementsChecker contributorAgreements;

    @Inject
    Revert(Provider<ReviewDb> db, PermissionBackend permissionBackend, GitRepositoryManager repoManager, ChangeInserter.Factory changeInserterFactory, ChangeMessagesUtil cmUtil, RetryHelper retryHelper, Sequences seq, PatchSetUtil psUtil, RevertedSender.Factory revertedSenderFactory, ChangeJson.Factory json, @GerritPersonIdent PersonIdent serverIdent, ApprovalsUtil approvalsUtil, ChangeReverted changeReverted, ContributorAgreementsChecker contributorAgreements) {
        super(retryHelper);
        this.db = db;
        this.permissionBackend = permissionBackend;
        this.repoManager = repoManager;
        this.changeInserterFactory = changeInserterFactory;
        this.cmUtil = cmUtil;
        this.seq = seq;
        this.psUtil = psUtil;
        this.revertedSenderFactory = revertedSenderFactory;
        this.json = json;
        this.serverIdent = serverIdent;
        this.approvalsUtil = approvalsUtil;
        this.changeReverted = changeReverted;
        this.contributorAgreements = contributorAgreements;
    }

    @Override
    public ChangeInfo applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, RevertInput input) throws IOException, OrmException, RestApiException, UpdateException, NoSuchChangeException, PermissionBackendException, NoSuchProjectException {
        Change change = rsrc.getChange();
        if (change.getStatus() != Change.Status.MERGED) {
            throw new ResourceConflictException("change is " + ChangeUtil.status(change));
        }
        this.contributorAgreements.check(rsrc.getProject(), rsrc.getUser());
        this.permissionBackend.user(rsrc.getUser()).ref(change.getDest()).check(RefPermission.CREATE_CHANGE);
        Change.Id revertId = this.revert(updateFactory, rsrc.getNotes(), rsrc.getUser(), Strings.emptyToNull(input.message));
        return this.json.noOptions().format(rsrc.getProject(), revertId);
    }

    /*
     * Exception decompiling
     */
    private Change.Id revert(BatchUpdate.Factory updateFactory, ChangeNotes notes, CurrentUser user, String message) throws OrmException, IOException, RestApiException, UpdateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 29[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        Change change = rsrc.getChange();
        return new UiAction.Description().setLabel("Revert").setTitle("Revert the change").setVisible(BooleanCondition.and(change.getStatus() == Change.Status.MERGED, this.permissionBackend.user(rsrc.getUser()).ref(change.getDest()).testCond(RefPermission.CREATE_CHANGE)));
    }

    private class PostRevertedMessageOp
    implements BatchUpdateOp {
        private final ObjectId computedChangeId;

        PostRevertedMessageOp(ObjectId computedChangeId) {
            this.computedChangeId = computedChangeId;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws Exception {
            Change change = ctx.getChange();
            PatchSet.Id patchSetId = change.currentPatchSetId();
            ChangeMessage changeMessage = ChangeMessagesUtil.newMessage(ctx, "Created a revert of this change as I" + this.computedChangeId.name(), "autogenerated:gerrit:revert");
            Revert.this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(patchSetId), changeMessage);
            return true;
        }
    }

    private class NotifyOp
    implements BatchUpdateOp {
        private final Change change;
        private final ChangeInserter ins;

        NotifyOp(Change change, ChangeInserter ins) {
            this.change = change;
            this.ins = ins;
        }

        @Override
        public void postUpdate(Context ctx) throws Exception {
            Revert.this.changeReverted.fire(this.change, this.ins.getChange(), ctx.getWhen());
            try {
                RevertedSender cm = Revert.this.revertedSenderFactory.create(ctx.getProject(), this.change.getId());
                cm.setFrom(ctx.getAccountId());
                cm.send();
            }
            catch (Exception err) {
                log.error("Cannot send email for revert change " + this.change.getId(), err);
            }
        }
    }
}

