/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.AccountVisibility;
import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ReviewersUtil;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.SuggestReviewers;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Option;

public class SuggestChangeReviewers
extends SuggestReviewers
implements RestReadView<ChangeResource> {
    @Option(name="--exclude-groups", aliases={"-e"}, usage="exclude groups from query")
    boolean excludeGroups;
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> self;
    private final ProjectCache projectCache;

    @Inject
    SuggestChangeReviewers(AccountVisibility av, IdentifiedUser.GenericFactory identifiedUserFactory, Provider<ReviewDb> dbProvider, PermissionBackend permissionBackend, Provider<CurrentUser> self, @GerritServerConfig Config cfg, ReviewersUtil reviewersUtil, ProjectCache projectCache) {
        super(av, identifiedUserFactory, dbProvider, cfg, reviewersUtil);
        this.permissionBackend = permissionBackend;
        this.self = self;
        this.projectCache = projectCache;
    }

    public List<SuggestedReviewerInfo> apply(ChangeResource rsrc) throws AuthException, BadRequestException, OrmException, IOException, ConfigInvalidException {
        if (!this.self.get().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.reviewersUtil.suggestReviewers(rsrc.getNotes(), this, this.projectCache.checkedGet(rsrc.getProject()), this.getVisibility(rsrc), this.excludeGroups);
    }

    private ReviewersUtil.VisibilityControl getVisibility(ChangeResource rsrc) {
        final PermissionBackend.ForRef perm = this.permissionBackend.user(this.self).ref(rsrc.getChange().getDest());
        return new ReviewersUtil.VisibilityControl(){

            @Override
            public boolean isVisibleTo(Account.Id account) throws OrmException {
                IdentifiedUser who = SuggestChangeReviewers.this.identifiedUserFactory.create(account);
                return perm.user(who).testOrFalse(RefPermission.READ);
            }
        };
    }
}

