/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.server.account.DefaultRealm;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.auth.AuthBackend;
import com.google.gerrit.server.auth.InternalAuthBackend;
import com.google.gerrit.server.auth.ldap.LdapModule;
import com.google.gerrit.server.auth.oauth.OAuthRealm;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;

public class AuthModule
extends AbstractModule {
    private final AuthType loginType;

    @Inject
    AuthModule(AuthConfig authConfig) {
        this.loginType = authConfig.getAuthType();
    }

    @Override
    protected void configure() {
        switch (this.loginType) {
            case HTTP_LDAP: 
            case LDAP: 
            case LDAP_BIND: 
            case CLIENT_SSL_CERT_LDAP: {
                this.install(new LdapModule());
                break;
            }
            case OAUTH: {
                this.bind(Realm.class).to(OAuthRealm.class);
                break;
            }
            case CUSTOM_EXTENSION: {
                break;
            }
            default: {
                this.bind(Realm.class).to(DefaultRealm.class);
                DynamicSet.bind(this.binder(), AuthBackend.class).to(InternalAuthBackend.class);
            }
        }
    }
}

