/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.api.config.ConsistencyCheckInfo;
import com.google.gerrit.extensions.api.config.ConsistencyCheckInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountsConsistencyChecker;
import com.google.gerrit.server.account.externalids.ExternalIdsConsistencyChecker;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class CheckConsistency
implements RestModifyView<ConfigResource, ConsistencyCheckInput> {
    private final PermissionBackend permissionBackend;
    private final Provider<CurrentUser> user;
    private final AccountsConsistencyChecker accountsConsistencyChecker;
    private final ExternalIdsConsistencyChecker externalIdsConsistencyChecker;

    @Inject
    CheckConsistency(PermissionBackend permissionBackend, Provider<CurrentUser> user, AccountsConsistencyChecker accountsConsistencyChecker, ExternalIdsConsistencyChecker externalIdsConsistencyChecker) {
        this.permissionBackend = permissionBackend;
        this.user = user;
        this.accountsConsistencyChecker = accountsConsistencyChecker;
        this.externalIdsConsistencyChecker = externalIdsConsistencyChecker;
    }

    public ConsistencyCheckInfo apply(ConfigResource resource, ConsistencyCheckInput input) throws RestApiException, IOException, OrmException, PermissionBackendException {
        this.permissionBackend.user(this.user).check(GlobalPermission.ACCESS_DATABASE);
        if (input == null || input.checkAccounts == null && input.checkAccountExternalIds == null) {
            throw new BadRequestException("input required");
        }
        ConsistencyCheckInfo consistencyCheckInfo = new ConsistencyCheckInfo();
        if (input.checkAccounts != null) {
            consistencyCheckInfo.checkAccountsResult = new ConsistencyCheckInfo.CheckAccountsResultInfo(this.accountsConsistencyChecker.check());
        }
        if (input.checkAccountExternalIds != null) {
            consistencyCheckInfo.checkAccountExternalIdsResult = new ConsistencyCheckInfo.CheckAccountExternalIdsResultInfo(this.externalIdsConsistencyChecker.check());
        }
        return consistencyCheckInfo;
    }
}

