/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.gerrit.common.EventListener;
import com.google.gerrit.metrics.Counter1;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.server.events.Event;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class EventsMetrics
implements EventListener {
    private final Counter1<String> events;

    @Inject
    public EventsMetrics(MetricMaker metricMaker) {
        this.events = metricMaker.newCounter("events", new Description("Triggered events").setRate().setUnit("triggered events"), Field.ofString("type"));
    }

    @Override
    public void onEvent(Event event) {
        this.events.increment(event.getType());
    }
}

