/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.RefNames;
import java.util.List;

public class BranchOrderSection {
    private final ImmutableList<String> order;

    public BranchOrderSection(String[] order) {
        if (order.length == 0) {
            this.order = ImmutableList.of();
        } else {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String b : order) {
                builder.add(RefNames.fullName(b));
            }
            this.order = builder.build();
        }
    }

    public String[] getMoreStable(String branch) {
        int i = this.order.indexOf(RefNames.fullName(branch));
        if (0 <= i) {
            List r = this.order.subList(i + 1, this.order.size());
            return r.toArray(new String[r.size()]);
        }
        return new String[0];
    }
}

