/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsUpdate;
import com.google.gerrit.server.group.UserInitiated;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Objects;

@Singleton
public class PutDescription
implements RestModifyView<GroupResource, Input> {
    private final Provider<ReviewDb> db;
    private final Provider<GroupsUpdate> groupsUpdateProvider;

    @Inject
    PutDescription(Provider<ReviewDb> db, @UserInitiated Provider<GroupsUpdate> groupsUpdateProvider) {
        this.db = db;
        this.groupsUpdateProvider = groupsUpdateProvider;
    }

    public Response<String> apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException, IOException {
        if (input == null) {
            input = new Input();
        }
        GroupDescription.Internal internalGroup = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        if (!resource.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        String newDescription = Strings.emptyToNull(input.description);
        if (!Objects.equals(internalGroup.getDescription(), newDescription)) {
            AccountGroup.UUID groupUuid = internalGroup.getGroupUUID();
            try {
                this.groupsUpdateProvider.get().updateGroup(this.db.get(), groupUuid, group -> group.setDescription(newDescription));
            }
            catch (NoSuchGroupException e) {
                throw new ResourceNotFoundException(String.format("Group %s not found", groupUuid));
            }
        }
        return Strings.isNullOrEmpty(input.description) ? Response.none() : Response.ok(input.description);
    }

    public static class Input {
        @DefaultInput
        public String description;
    }
}

