/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.account;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.index.SiteIndexer;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.account.AccountIndex;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AllAccountsIndexer
extends SiteIndexer<Account.Id, AccountState, AccountIndex> {
    private static final Logger log = LoggerFactory.getLogger(AllAccountsIndexer.class);
    private final ListeningExecutorService executor;
    private final Accounts accounts;
    private final AccountCache accountCache;

    @Inject
    AllAccountsIndexer(@IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor, Accounts accounts, AccountCache accountCache) {
        this.executor = executor;
        this.accounts = accounts;
        this.accountCache = accountCache;
    }

    @Override
    public SiteIndexer.Result indexAll(AccountIndex index) {
        List<Account.Id> ids;
        TextProgressMonitor progress = new TextProgressMonitor(this.newPrintWriter(this.progressOut));
        progress.start(2);
        Stopwatch sw = Stopwatch.createStarted();
        try {
            ids = this.collectAccounts(progress);
        }
        catch (IOException e) {
            log.error("Error collecting accounts", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        return this.reindexAccounts(index, ids, progress);
    }

    private SiteIndexer.Result reindexAccounts(AccountIndex index, List<Account.Id> ids, ProgressMonitor progress) {
        progress.beginTask("Reindexing accounts", ids.size());
        ArrayList<Future> futures = new ArrayList<Future>(ids.size());
        AtomicBoolean ok = new AtomicBoolean(true);
        AtomicInteger done = new AtomicInteger();
        AtomicInteger failed = new AtomicInteger();
        Stopwatch sw = Stopwatch.createStarted();
        for (Account.Id id : ids) {
            String desc = "account " + id;
            Future future = this.executor.submit(() -> {
                try {
                    this.accountCache.evict(id);
                    index.replace(this.accountCache.get(id));
                    this.verboseWriter.println("Reindexed " + desc);
                    done.incrementAndGet();
                }
                catch (Exception e) {
                    failed.incrementAndGet();
                    throw e;
                }
                return null;
            });
            this.addErrorListener((ListenableFuture<?>)future, desc, progress, ok);
            futures.add(future);
        }
        try {
            Futures.successfulAsList(futures).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Error waiting on account futures", e);
            return new SiteIndexer.Result(sw, false, 0, 0);
        }
        progress.endTask();
        return new SiteIndexer.Result(sw, ok.get(), done.get(), failed.get());
    }

    private List<Account.Id> collectAccounts(ProgressMonitor progress) throws IOException {
        progress.beginTask("Collecting accounts", 0);
        ArrayList<Account.Id> ids = new ArrayList<Account.Id>();
        for (Account.Id accountId : this.accounts.allIds()) {
            ids.add(accountId);
            progress.update(1);
        }
        progress.endTask();
        return ids;
    }
}

