/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.OutgoingEmail;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;

public class HttpPasswordUpdateSender
extends OutgoingEmail {
    private final IdentifiedUser user;
    private final String operation;

    @AssistedInject
    public HttpPasswordUpdateSender(EmailArguments ea, @Assisted IdentifiedUser user, @Assisted String operation) {
        super(ea, "HttpPasswordUpdate");
        this.user = user;
        this.operation = operation;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setHeader("Subject", "[Gerrit Code Review] HTTP password was " + this.operation);
        this.add(RecipientType.TO, new Address(this.getEmail()));
    }

    @Override
    protected boolean shouldSendMessage() {
        return true;
    }

    @Override
    protected void format() throws EmailException {
        this.appendText(this.textTemplate("HttpPasswordUpdate"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("HttpPasswordUpdateHtml"));
        }
    }

    public String getEmail() {
        return this.user.getAccount().getPreferredEmail();
    }

    public String getUserNameEmail() {
        return this.getUserNameEmailFor(this.user.getAccountId());
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("email", this.getEmail());
        this.soyContextEmailData.put("userNameEmail", this.getUserNameEmail());
        this.soyContextEmailData.put("operation", this.operation);
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public HttpPasswordUpdateSender create(IdentifiedUser var1, String var2);
    }
}

