/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.gerrit.server.notedb.AutoValue_NotesMigration_Snapshot;
import com.google.gerrit.server.notedb.MutableNotesMigration;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.inject.AbstractModule;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.lib.Config;

public abstract class NotesMigration {
    public static final String SECTION_NOTE_DB = "noteDb";
    private static final String DISABLE_REVIEW_DB = "disableReviewDb";
    private static final String PRIMARY_STORAGE = "primaryStorage";
    private static final String READ = "read";
    private static final String SEQUENCE = "sequence";
    private static final String WRITE = "write";
    protected final AtomicReference<Snapshot> snapshot;

    public final boolean readChanges() {
        return this.snapshot.get().readChanges();
    }

    public final boolean rawWriteChangesSetting() {
        return this.snapshot.get().writeChanges();
    }

    public final boolean readChangeSequence() {
        return this.snapshot.get().readChangeSequence();
    }

    public final NoteDbChangeState.PrimaryStorage changePrimaryStorage() {
        return this.snapshot.get().changePrimaryStorage();
    }

    public final boolean disableChangeReviewDb() {
        return this.snapshot.get().disableChangeReviewDb();
    }

    public boolean failOnLoadForTest() {
        return this.snapshot.get().failOnLoadForTest();
    }

    public final boolean commitChangeWrites() {
        return this.rawWriteChangesSetting() || this.readChanges();
    }

    public final boolean failChangeWrites() {
        return !this.rawWriteChangesSetting() && this.readChanges();
    }

    public final void setConfigValues(Config cfg) {
        this.snapshot.get().setConfigValues(cfg);
    }

    public final boolean equals(Object o) {
        return o instanceof NotesMigration && this.snapshot.get().equals(((NotesMigration)o).snapshot.get());
    }

    public final int hashCode() {
        return this.snapshot.get().hashCode();
    }

    protected NotesMigration(Snapshot snapshot) {
        this.snapshot = new AtomicReference<Snapshot>(snapshot);
    }

    final Snapshot snapshot() {
        return this.snapshot.get();
    }

    @AutoValue
    static abstract class Snapshot {
        Snapshot() {
        }

        static Builder builder() {
            return Snapshot.create(new Config()).toBuilder();
        }

        static Snapshot create(Config cfg) {
            return new AutoValue_NotesMigration_Snapshot.Builder().setWriteChanges(cfg.getBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.WRITE, false)).setReadChanges(cfg.getBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.READ, false)).setReadChangeSequence(cfg.getBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.SEQUENCE, false)).setChangePrimaryStorage(cfg.getEnum(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.PRIMARY_STORAGE, NoteDbChangeState.PrimaryStorage.REVIEW_DB)).setDisableChangeReviewDb(cfg.getBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.DISABLE_REVIEW_DB, false)).setFailOnLoadForTest(false).build();
        }

        abstract boolean writeChanges();

        abstract boolean readChanges();

        abstract boolean readChangeSequence();

        abstract NoteDbChangeState.PrimaryStorage changePrimaryStorage();

        abstract boolean disableChangeReviewDb();

        abstract boolean failOnLoadForTest();

        abstract Builder toBuilder();

        void setConfigValues(Config cfg) {
            cfg.setBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.WRITE, this.writeChanges());
            cfg.setBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.READ, this.readChanges());
            cfg.setBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.SEQUENCE, this.readChangeSequence());
            cfg.setEnum(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.PRIMARY_STORAGE, this.changePrimaryStorage());
            cfg.setBoolean(NotesMigration.SECTION_NOTE_DB, NoteDbTable.CHANGES.key(), NotesMigration.DISABLE_REVIEW_DB, this.disableChangeReviewDb());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setWriteChanges(boolean var1);

            abstract Builder setReadChanges(boolean var1);

            abstract Builder setReadChangeSequence(boolean var1);

            abstract Builder setChangePrimaryStorage(NoteDbChangeState.PrimaryStorage var1);

            abstract Builder setDisableChangeReviewDb(boolean var1);

            abstract Builder setFailOnLoadForTest(boolean var1);

            abstract Snapshot autoBuild();

            Snapshot build() {
                Snapshot s = this.autoBuild();
                Preconditions.checkArgument(!s.disableChangeReviewDb() || s.changePrimaryStorage() == NoteDbChangeState.PrimaryStorage.NOTE_DB, "cannot disable ReviewDb for changes if default change primary storage is ReviewDb");
                return s;
            }
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        public void configure() {
            this.bind(MutableNotesMigration.class);
            this.bind(NotesMigration.class).to(MutableNotesMigration.class);
        }
    }
}

