/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.Event;
import com.google.gwtorm.server.OrmException;
import java.util.Objects;

class FinalUpdatesEvent
extends Event {
    private final Change change;
    private final Change noteDbChange;
    private final ImmutableCollection<PatchSet> patchSets;

    FinalUpdatesEvent(Change change, Change noteDbChange, ImmutableCollection<PatchSet> patchSets) {
        super(change.currentPatchSetId(), change.getOwner(), change.getOwner(), change.getLastUpdatedOn(), change.getCreatedOn(), null);
        this.change = change;
        this.noteDbChange = noteDbChange;
        this.patchSets = patchSets;
    }

    @Override
    boolean uniquePerUpdate() {
        return true;
    }

    @Override
    void apply(ChangeUpdate update) throws OrmException {
        if (!Objects.equals(this.change.getTopic(), this.noteDbChange.getTopic())) {
            update.setTopic(this.change.getTopic());
        }
        if (!this.statusMatches()) {
            update.fixStatus(this.change.getStatus());
        }
        if (this.change.isPrivate() != this.noteDbChange.isPrivate()) {
            update.setPrivate(this.change.isPrivate());
        }
        if (this.change.isWorkInProgress() != this.noteDbChange.isWorkInProgress()) {
            update.setWorkInProgress(this.change.isWorkInProgress());
        }
        if (this.change.getSubmissionId() != null && this.noteDbChange.getSubmissionId() == null) {
            update.setSubmissionId(this.change.getSubmissionId());
        }
        if (!Objects.equals(this.change.getAssignee(), this.noteDbChange.getAssignee())) {
            update.setAssignee(this.change.getAssignee());
        }
        if (!this.patchSets.isEmpty() && !this.highestNumberedPatchSetIsCurrent()) {
            update.setCurrentPatchSet();
        }
        if (!update.isEmpty()) {
            update.setSubjectForCommit("Final NoteDb migration updates");
        }
    }

    private boolean statusMatches() {
        return Objects.equals((Object)this.change.getStatus(), (Object)this.noteDbChange.getStatus());
    }

    private boolean highestNumberedPatchSetIsCurrent() {
        PatchSet.Id max = this.patchSets.stream().map(PatchSet::getId).max(ReviewDbUtil.intKeyOrdering()).get();
        return max.equals(this.change.currentPatchSetId());
    }

    @Override
    protected boolean isSubmit() {
        return this.change.getStatus() == Change.Status.MERGED;
    }

    @Override
    protected void addToString(MoreObjects.ToStringHelper helper) {
        if (!this.statusMatches()) {
            helper.add("status", (Object)this.change.getStatus());
        }
    }
}

