/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.permissions;

import com.google.gerrit.extensions.api.access.GlobalOrPluginPermission;
import com.google.gerrit.extensions.conditions.PrivateInternals_BooleanCondition;
import com.google.gerrit.server.permissions.ChangePermissionOrLabel;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;

public abstract class PermissionBackendCondition
extends PrivateInternals_BooleanCondition.SubclassOnlyInCoreServer {
    Boolean value;

    public void set(boolean val) {
        this.value = val;
    }

    public abstract String toString();

    public static class ForChange
    extends PermissionBackendCondition {
        private final PermissionBackend.ForChange impl;
        private final ChangePermissionOrLabel perm;

        ForChange(PermissionBackend.ForChange impl, ChangePermissionOrLabel perm) {
            this.impl = impl;
            this.perm = perm;
        }

        public PermissionBackend.ForChange change() {
            return this.impl;
        }

        public ChangePermissionOrLabel permission() {
            return this.perm;
        }

        @Override
        public boolean value() {
            return this.value != null ? this.value.booleanValue() : this.impl.testOrFalse(this.perm);
        }

        @Override
        public String toString() {
            return "PermissionBackendCondition.ForChange(" + this.perm + ")";
        }
    }

    public static class ForRef
    extends PermissionBackendCondition {
        private final PermissionBackend.ForRef impl;
        private final RefPermission perm;

        ForRef(PermissionBackend.ForRef impl, RefPermission perm) {
            this.impl = impl;
            this.perm = perm;
        }

        public PermissionBackend.ForRef ref() {
            return this.impl;
        }

        public RefPermission permission() {
            return this.perm;
        }

        @Override
        public boolean value() {
            return this.value != null ? this.value.booleanValue() : this.impl.testOrFalse(this.perm);
        }

        @Override
        public String toString() {
            return "PermissionBackendCondition.ForRef(" + (Object)((Object)this.perm) + ")";
        }
    }

    public static class ForProject
    extends PermissionBackendCondition {
        private final PermissionBackend.ForProject impl;
        private final ProjectPermission perm;

        ForProject(PermissionBackend.ForProject impl, ProjectPermission perm) {
            this.impl = impl;
            this.perm = perm;
        }

        public PermissionBackend.ForProject project() {
            return this.impl;
        }

        public ProjectPermission permission() {
            return this.perm;
        }

        @Override
        public boolean value() {
            return this.value != null ? this.value.booleanValue() : this.impl.testOrFalse(this.perm);
        }

        @Override
        public String toString() {
            return "PermissionBackendCondition.ForProject(" + (Object)((Object)this.perm) + ")";
        }
    }

    public static class WithUser
    extends PermissionBackendCondition {
        private final PermissionBackend.WithUser impl;
        private final GlobalOrPluginPermission perm;

        WithUser(PermissionBackend.WithUser impl, GlobalOrPluginPermission perm) {
            this.impl = impl;
            this.perm = perm;
        }

        public PermissionBackend.WithUser withUser() {
            return this.impl;
        }

        public GlobalOrPluginPermission permission() {
            return this.perm;
        }

        @Override
        public boolean value() {
            return this.value != null ? this.value.booleanValue() : this.impl.testOrFalse(this.perm);
        }

        @Override
        public String toString() {
            return "PermissionBackendCondition.WithUser(" + this.perm + ")";
        }
    }
}

