/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.extensions.annotations.Export;
import com.google.gerrit.extensions.annotations.ExtensionPoint;
import com.google.gerrit.extensions.annotations.Listen;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.webui.JavaScriptPlugin;
import com.google.gerrit.extensions.webui.WebUiPlugin;
import com.google.gerrit.server.plugins.AutoRegisterUtil;
import com.google.gerrit.server.plugins.InvalidPluginException;
import com.google.gerrit.server.plugins.ModuleGenerator;
import com.google.gerrit.server.plugins.PluginContentScanner;
import com.google.gerrit.server.plugins.PluginGuiceEnvironment;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AutoRegisterModules {
    private static final Logger log = LoggerFactory.getLogger(AutoRegisterModules.class);
    private final String pluginName;
    private final PluginGuiceEnvironment env;
    private final PluginContentScanner scanner;
    private final ClassLoader classLoader;
    private final ModuleGenerator sshGen;
    private final ModuleGenerator httpGen;
    private Set<Class<?>> sysSingletons;
    private ListMultimap<TypeLiteral<?>, Class<?>> sysListen;
    private String initJs;
    Module sysModule;
    Module sshModule;
    Module httpModule;

    AutoRegisterModules(String pluginName, PluginGuiceEnvironment env, PluginContentScanner scanner, ClassLoader classLoader) {
        this.pluginName = pluginName;
        this.env = env;
        this.scanner = scanner;
        this.classLoader = classLoader;
        this.sshGen = env.hasSshModule() ? env.newSshModuleGenerator() : new ModuleGenerator.NOP();
        this.httpGen = env.hasHttpModule() ? env.newHttpModuleGenerator() : new ModuleGenerator.NOP();
    }

    AutoRegisterModules discover() throws InvalidPluginException {
        this.sysSingletons = new HashSet();
        this.sysListen = LinkedListMultimap.create();
        this.initJs = null;
        this.sshGen.setPluginName(this.pluginName);
        this.httpGen.setPluginName(this.pluginName);
        this.scan();
        if (!this.sysSingletons.isEmpty() || !this.sysListen.isEmpty() || this.initJs != null) {
            this.sysModule = this.makeSystemModule();
        }
        this.sshModule = this.sshGen.create();
        this.httpModule = this.httpGen.create();
        return this;
    }

    private Module makeSystemModule() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                for (Class clazz : AutoRegisterModules.this.sysSingletons) {
                    this.bind(clazz).in(Scopes.SINGLETON);
                }
                for (Map.Entry entry : AutoRegisterModules.this.sysListen.entries()) {
                    TypeLiteral type = (TypeLiteral)entry.getKey();
                    Class impl = (Class)entry.getValue();
                    Annotation n = AutoRegisterUtil.calculateBindAnnotation(impl);
                    this.bind(type).annotatedWith(n).to(impl);
                }
                if (AutoRegisterModules.this.initJs != null) {
                    DynamicSet.bind(this.binder(), WebUiPlugin.class).toInstance(new JavaScriptPlugin(AutoRegisterModules.this.initJs));
                }
            }
        };
    }

    private void scan() throws InvalidPluginException {
        Map<Class<? extends Annotation>, Iterable<PluginContentScanner.ExtensionMetaData>> extensions = this.scanner.scan(this.pluginName, Arrays.asList(Export.class, Listen.class));
        for (PluginContentScanner.ExtensionMetaData export : extensions.get(Export.class)) {
            this.export(export);
        }
        for (PluginContentScanner.ExtensionMetaData listener : extensions.get(Listen.class)) {
            this.listen(listener);
        }
        if (this.env.hasHttpModule()) {
            this.exportInitJs();
        }
    }

    private void exportInitJs() {
        try {
            if (this.scanner.getEntry("static/init.js").isPresent()) {
                this.initJs = "static/init.js";
            }
        }
        catch (IOException e) {
            log.warn("Cannot access {} from plugin {}: JavaScript auto-discovered plugin will not be registered", "static/init.js", this.pluginName, e);
        }
    }

    private void export(PluginContentScanner.ExtensionMetaData def) throws InvalidPluginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(def.className, false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new InvalidPluginException(String.format("Cannot load %s with @Export(\"%s\")", def.className, def.annotationValue), err);
        }
        Export export = clazz.getAnnotation(Export.class);
        if (export == null) {
            log.warn("In plugin {} asm incorrectly parsed {} with @Export(\"{}\")", this.pluginName, clazz.getName(), def.annotationValue);
            return;
        }
        if (PluginGuiceEnvironment.is("org.apache.sshd.server.Command", clazz)) {
            this.sshGen.export(export, clazz);
        } else if (PluginGuiceEnvironment.is("javax.servlet.http.HttpServlet", clazz)) {
            this.httpGen.export(export, clazz);
            this.listen(clazz, clazz);
        } else {
            int cnt = this.sysListen.size();
            this.listen(clazz, clazz);
            if (cnt == this.sysListen.size()) {
                throw new InvalidPluginException(String.format("Class %s with @Export(\"%s\") not supported", clazz.getName(), export.value()));
            }
        }
    }

    private void listen(PluginContentScanner.ExtensionMetaData def) throws InvalidPluginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(def.className, false, this.classLoader);
        }
        catch (ClassNotFoundException err) {
            throw new InvalidPluginException(String.format("Cannot load %s with @Listen", def.className), err);
        }
        Listen listen = clazz.getAnnotation(Listen.class);
        if (listen != null) {
            this.listen(clazz, clazz);
        } else {
            log.warn("In plugin {} asm incorrectly parsed {} with @Listen", (Object)this.pluginName, (Object)clazz.getName());
        }
    }

    private void listen(Type type, Class<?> clazz) throws InvalidPluginException {
        while (type != null) {
            Class rawType;
            if (type instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)type).getRawType();
            } else if (type instanceof Class) {
                rawType = (Class)type;
            } else {
                return;
            }
            if (rawType.getAnnotation(ExtensionPoint.class) != null) {
                TypeLiteral<?> tl = TypeLiteral.get(type);
                if (this.env.hasDynamicItem(tl)) {
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else if (this.env.hasDynamicSet(tl)) {
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else if (this.env.hasDynamicMap(tl)) {
                    if (clazz.getAnnotation(Export.class) == null) {
                        throw new InvalidPluginException(String.format("Class %s requires @Export(\"name\") annotation for %s", clazz.getName(), rawType.getName()));
                    }
                    this.sysSingletons.add(clazz);
                    this.sysListen.put(tl, clazz);
                    this.httpGen.listen(tl, clazz);
                    this.sshGen.listen(tl, clazz);
                } else {
                    throw new InvalidPluginException(String.format("Cannot register %s, server does not accept %s", clazz.getName(), rawType.getName()));
                }
                return;
            }
            Type[] interfaces = rawType.getGenericInterfaces();
            if (interfaces != null) {
                for (Type i : interfaces) {
                    this.listen(i, clazz);
                }
            }
            type = rawType.getGenericSuperclass();
        }
    }
}

