/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.CommonConverters;
import com.google.gerrit.server.project.CommitResource;
import com.google.inject.Singleton;
import java.util.ArrayList;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
public class GetCommit
implements RestReadView<CommitResource> {
    public CommitInfo apply(CommitResource rsrc) {
        return GetCommit.toCommitInfo(rsrc.getCommit());
    }

    private static CommitInfo toCommitInfo(RevCommit commit) {
        CommitInfo info = new CommitInfo();
        info.commit = commit.getName();
        info.author = CommonConverters.toGitPerson(commit.getAuthorIdent());
        info.committer = CommonConverters.toGitPerson(commit.getCommitterIdent());
        info.subject = commit.getShortMessage();
        info.message = commit.getFullMessage();
        info.parents = new ArrayList<CommitInfo>(commit.getParentCount());
        for (int i = 0; i < commit.getParentCount(); ++i) {
            RevCommit p = commit.getParent(i);
            CommitInfo parentInfo = new CommitInfo();
            parentInfo.commit = p.getName();
            parentInfo.subject = p.getShortMessage();
            info.parents.add(parentInfo);
        }
        return info;
    }
}

