/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.OutputFormat;
import com.google.gerrit.server.StringUtil;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectNode;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.util.RegexListSearcher;
import com.google.gerrit.server.util.TreeFormatter;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProjects
implements RestReadView<TopLevelResource> {
    private static final Logger log = LoggerFactory.getLogger(ListProjects.class);
    private final CurrentUser currentUser;
    private final ProjectCache projectCache;
    private final GroupsCollection groupsCollection;
    private final GroupControl.Factory groupControlFactory;
    private final GitRepositoryManager repoManager;
    private final PermissionBackend permissionBackend;
    private final ProjectNode.Factory projectNodeFactory;
    private final WebLinks webLinks;
    @Deprecated
    @Option(name="--format", usage="(deprecated) output format")
    private OutputFormat format = OutputFormat.TEXT;
    private final List<String> showBranch = new ArrayList<String>();
    private boolean showTree;
    private FilterType type = FilterType.ALL;
    private boolean showDescription;
    private boolean all;
    private int limit;
    private int start;
    private String matchPrefix;
    private String matchSubstring;
    private String matchRegex;
    private AccountGroup.UUID groupUuid;

    @Option(name="--show-branch", aliases={"-b"}, usage="displays the sha of each project in the specified branch")
    public void addShowBranch(String branch) {
        this.showBranch.add(branch);
    }

    @Option(name="--tree", aliases={"-t"}, usage="displays project inheritance in a tree-like format\nthis option does not work together with the show-branch option")
    public void setShowTree(boolean showTree) {
        this.showTree = showTree;
    }

    @Option(name="--type", usage="type of project")
    public void setFilterType(FilterType type) {
        this.type = type;
    }

    @Option(name="--description", aliases={"-d"}, usage="include description of project in list")
    public void setShowDescription(boolean showDescription) {
        this.showDescription = showDescription;
    }

    @Option(name="--all", usage="display all projects that are accessible by the calling user")
    public void setAll(boolean all) {
        this.all = all;
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of projects to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of projects to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--prefix", aliases={"-p"}, metaVar="PREFIX", usage="match project prefix")
    public void setMatchPrefix(String matchPrefix) {
        this.matchPrefix = matchPrefix;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match project substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="-r", metaVar="REGEX", usage="match project regex")
    public void setMatchRegex(String matchRegex) {
        this.matchRegex = matchRegex;
    }

    @Option(name="--has-acl-for", metaVar="GROUP", usage="displays only projects on which access rights for this group are directly assigned")
    public void setGroupUuid(AccountGroup.UUID groupUuid) {
        this.groupUuid = groupUuid;
    }

    @Inject
    protected ListProjects(CurrentUser currentUser, ProjectCache projectCache, GroupsCollection groupsCollection, GroupControl.Factory groupControlFactory, GitRepositoryManager repoManager, PermissionBackend permissionBackend, ProjectNode.Factory projectNodeFactory, WebLinks webLinks) {
        this.currentUser = currentUser;
        this.projectCache = projectCache;
        this.groupsCollection = groupsCollection;
        this.groupControlFactory = groupControlFactory;
        this.repoManager = repoManager;
        this.permissionBackend = permissionBackend;
        this.projectNodeFactory = projectNodeFactory;
        this.webLinks = webLinks;
    }

    public List<String> getShowBranch() {
        return this.showBranch;
    }

    public boolean isShowTree() {
        return this.showTree;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public OutputFormat getFormat() {
        return this.format;
    }

    public ListProjects setFormat(OutputFormat fmt) {
        this.format = fmt;
        return this;
    }

    @Override
    public Object apply(TopLevelResource resource) throws BadRequestException, PermissionBackendException {
        if (this.format == OutputFormat.TEXT) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            this.display(buf);
            return BinaryResult.create(buf.toByteArray()).setContentType("text/plain").setCharacterEncoding(StandardCharsets.UTF_8);
        }
        return this.apply();
    }

    public SortedMap<String, ProjectInfo> apply() throws BadRequestException, PermissionBackendException {
        this.format = OutputFormat.JSON;
        return this.display(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<String, ProjectInfo> display(@Nullable OutputStream displayOutputStream) throws BadRequestException, PermissionBackendException {
        if (this.groupUuid != null) {
            try {
                if (!this.groupControlFactory.controlFor(this.groupUuid).isVisible()) {
                    return Collections.emptySortedMap();
                }
            }
            catch (NoSuchGroupException ex) {
                return Collections.emptySortedMap();
            }
        }
        PrintWriter stdout = null;
        if (displayOutputStream != null) {
            stdout = new PrintWriter(new BufferedWriter(new OutputStreamWriter(displayOutputStream, StandardCharsets.UTF_8)));
        }
        if (this.type == FilterType.PARENT_CANDIDATES) {
            this.showDescription = true;
        }
        int foundIndex = 0;
        int found = 0;
        TreeMap<String, ProjectInfo> output = new TreeMap<String, ProjectInfo>();
        HashMap<String, String> hiddenNames = new HashMap<String, String>();
        HashMap<Project.NameKey, Boolean> accessibleParents = new HashMap<Project.NameKey, Boolean>();
        PermissionBackend.WithUser perm = this.permissionBackend.user(this.currentUser);
        TreeMap<Project.NameKey, ProjectNode> treeMap = new TreeMap<Project.NameKey, ProjectNode>();
        try {
            Object object;
            Iterable projectNames = this.filter(perm)::iterator;
            for (Project.NameKey projectName : projectNames) {
                ProjectInfo info;
                block48: {
                    ProjectState parent;
                    ProjectState e = this.projectCache.get(projectName);
                    if (e == null || !this.all && e.getProject().getState() == com.google.gerrit.extensions.client.ProjectState.HIDDEN) continue;
                    ProjectControl pctl = e.controlFor(this.currentUser);
                    if (this.groupUuid != null && !pctl.getProjectState().getLocalGroups().contains(GroupReference.forGroup(this.groupsCollection.parseId(this.groupUuid.get())))) continue;
                    info = new ProjectInfo();
                    if (this.showTree && !this.format.isJson()) {
                        treeMap.put(projectName, this.projectNodeFactory.create(pctl.getProject(), true));
                        continue;
                    }
                    info.name = projectName.get();
                    if (this.showTree && this.format.isJson() && (parent = (ProjectState)Iterables.getFirst(e.parents(), null)) != null) {
                        if (this.isParentAccessible(accessibleParents, perm, parent)) {
                            info.parent = parent.getName();
                        } else {
                            info.parent = (String)hiddenNames.get(parent.getName());
                            if (info.parent == null) {
                                info.parent = "?-" + (hiddenNames.size() + 1);
                                hiddenNames.put(parent.getName(), info.parent);
                            }
                        }
                    }
                    if (this.showDescription) {
                        info.description = Strings.emptyToNull(e.getProject().getDescription());
                    }
                    info.state = e.getProject().getState();
                    try {
                        Repository git;
                        if (!this.showBranch.isEmpty()) {
                            git = this.repoManager.openRepository(projectName);
                            try {
                                List<Ref> refs;
                                if (!this.type.matches(git) || !ListProjects.hasValidRef(refs = this.getBranchRefs(projectName, pctl))) continue;
                                for (int i = 0; i < this.showBranch.size(); ++i) {
                                    Ref ref = refs.get(i);
                                    if (ref == null || ref.getObjectId() == null) continue;
                                    if (info.branches == null) {
                                        info.branches = new LinkedHashMap<String, String>();
                                    }
                                    info.branches.put(this.showBranch.get(i), ref.getObjectId().name());
                                }
                                break block48;
                            }
                            finally {
                                if (git == null) continue;
                                git.close();
                                continue;
                            }
                        }
                        if (this.showTree || !this.type.useMatch()) break block48;
                        git = this.repoManager.openRepository(projectName);
                        try {
                            if (!this.type.matches(git)) {
                                continue;
                            }
                            break block48;
                        }
                        finally {
                            if (git == null) continue;
                            git.close();
                        }
                    }
                    catch (RepositoryNotFoundException err) {
                    }
                    catch (IOException err) {
                        log.warn("Unexpected error reading " + projectName, err);
                    }
                    continue;
                }
                if (this.type != FilterType.PARENT_CANDIDATES) {
                    List<WebLinkInfo> links = this.webLinks.getProjectLinks(projectName.get());
                    List<WebLinkInfo> list = info.webLinks = links.isEmpty() ? null : links;
                }
                if (foundIndex++ < this.start) continue;
                if (this.limit > 0 && ++found > this.limit) break;
                if (stdout == null || this.format.isJson()) {
                    output.put(info.name, info);
                    continue;
                }
                if (!this.showBranch.isEmpty()) {
                    for (String name : this.showBranch) {
                        String ref;
                        String string = ref = info.branches != null ? info.branches.get(name) : null;
                        if (ref == null) {
                            ref = "----------------------------------------";
                        }
                        stdout.print(ref);
                        stdout.print(' ');
                    }
                }
                stdout.print(info.name);
                if (info.description != null) {
                    stdout.print(" - " + StringUtil.escapeString(info.description));
                }
                stdout.print('\n');
            }
            for (ProjectInfo info : output.values()) {
                info.id = Url.encode(info.name);
                info.name = null;
            }
            if (stdout == null) {
                object = output;
                return object;
            }
            if (this.format.isJson()) {
                this.format.newGson().toJson(output, new TypeToken<Map<String, ProjectInfo>>(){}.getType(), stdout);
                stdout.print('\n');
            } else if (this.showTree && treeMap.size() > 0) {
                this.printProjectTree(stdout, treeMap);
            }
            object = null;
            return object;
        }
        finally {
            if (stdout != null) {
                stdout.flush();
            }
        }
    }

    private Stream<Project.NameKey> filter(PermissionBackend.WithUser perm) throws BadRequestException {
        Stream<Project.NameKey> matches = StreamSupport.stream(this.scan().spliterator(), false);
        if (this.type == FilterType.PARENT_CANDIDATES) {
            matches = matches.map(this.projectCache::get).map(this::parentOf).filter(Objects::nonNull).sorted();
        }
        return matches.filter((? super T p) -> perm.project((Project.NameKey)p).testOrFalse(ProjectPermission.ACCESS));
    }

    private Project.NameKey parentOf(ProjectState ps) {
        if (ps == null) {
            return null;
        }
        Project.NameKey parent = ps.getProject().getParent();
        if (parent != null) {
            if (this.projectCache.get(parent) != null) {
                return parent;
            }
            log.warn("parent project {} of project {} not found", (Object)parent.get(), (Object)ps.getName());
        }
        return null;
    }

    private boolean isParentAccessible(Map<Project.NameKey, Boolean> checked, PermissionBackend.WithUser perm, ProjectState p) throws PermissionBackendException {
        Project.NameKey name = p.getNameKey();
        Boolean b = checked.get(name);
        if (b == null) {
            try {
                perm.project(name).check(ProjectPermission.ACCESS);
                b = true;
            }
            catch (AuthException denied) {
                b = false;
            }
            checked.put(name, b);
        }
        return b;
    }

    private Iterable<Project.NameKey> scan() throws BadRequestException {
        if (this.matchPrefix != null) {
            ListProjects.checkMatchOptions(this.matchSubstring == null && this.matchRegex == null);
            return this.projectCache.byName(this.matchPrefix);
        }
        if (this.matchSubstring != null) {
            ListProjects.checkMatchOptions(this.matchPrefix == null && this.matchRegex == null);
            return Iterables.filter(this.projectCache.all(), p -> p.get().toLowerCase(Locale.US).contains(this.matchSubstring.toLowerCase(Locale.US)));
        }
        if (this.matchRegex != null) {
            RegexListSearcher<Project.NameKey> searcher;
            ListProjects.checkMatchOptions(this.matchPrefix == null && this.matchSubstring == null);
            try {
                searcher = new RegexListSearcher<Project.NameKey>(this.matchRegex){

                    @Override
                    public String apply(Project.NameKey in) {
                        return in.get();
                    }
                };
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(e.getMessage());
            }
            return searcher.search(ImmutableList.copyOf(this.projectCache.all()));
        }
        return this.projectCache.all();
    }

    private static void checkMatchOptions(boolean cond) throws BadRequestException {
        if (!cond) {
            throw new BadRequestException("specify exactly one of p/m/r");
        }
    }

    private void printProjectTree(PrintWriter stdout, TreeMap<Project.NameKey, ProjectNode> treeMap) {
        TreeSet<ProjectNode> sortedNodes = new TreeSet<ProjectNode>();
        for (ProjectNode key : treeMap.values()) {
            if (key.isAllProjects()) {
                sortedNodes.add(key);
                continue;
            }
            ProjectNode node = treeMap.get(key.getParentName());
            if (node != null) {
                node.addChild(key);
                continue;
            }
            sortedNodes.add(key);
        }
        TreeFormatter treeFormatter = new TreeFormatter(stdout);
        treeFormatter.printTree(sortedNodes);
        stdout.flush();
    }

    private List<Ref> getBranchRefs(Project.NameKey projectName, ProjectControl projectControl) {
        Ref[] result = new Ref[this.showBranch.size()];
        try (Repository git = this.repoManager.openRepository(projectName);){
            PermissionBackend.ForProject perm = this.permissionBackend.user(this.currentUser).project(projectName);
            for (int i = 0; i < this.showBranch.size(); ++i) {
                Ref ref = git.findRef(this.showBranch.get(i));
                if (this.all && projectControl.isOwner()) {
                    result[i] = ref;
                    continue;
                }
                if (ref == null || ref.getObjectId() == null) continue;
                try {
                    perm.ref(ref.getLeaf().getName()).check(RefPermission.READ);
                    result[i] = ref;
                    continue;
                }
                catch (AuthException e) {
                    // empty catch block
                }
            }
        }
        catch (PermissionBackendException | IOException exception) {
            // empty catch block
        }
        return Arrays.asList(result);
    }

    private static boolean hasValidRef(List<Ref> refs) {
        for (Ref ref : refs) {
            if (ref == null) continue;
            return true;
        }
        return false;
    }

    public static enum FilterType {
        CODE{

            @Override
            boolean matches(Repository git) throws IOException {
                return !PERMISSIONS.matches(git);
            }

            @Override
            boolean useMatch() {
                return true;
            }
        }
        ,
        PARENT_CANDIDATES{

            @Override
            boolean matches(Repository git) {
                return true;
            }

            @Override
            boolean useMatch() {
                return false;
            }
        }
        ,
        PERMISSIONS{

            @Override
            boolean matches(Repository git) throws IOException {
                Ref head = git.getRefDatabase().exactRef("HEAD");
                return head != null && head.isSymbolic() && "refs/meta/config".equals(head.getLeaf().getName());
            }

            @Override
            boolean useMatch() {
                return true;
            }
        }
        ,
        ALL{

            @Override
            boolean matches(Repository git) {
                return true;
            }

            @Override
            boolean useMatch() {
                return false;
            }
        };


        abstract boolean matches(Repository var1) throws IOException;

        abstract boolean useMatch();
    }
}

