/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;

@Singleton
public class RemoveReviewerControl {
    private final PermissionBackend permissionBackend;
    private final Provider<ReviewDb> dbProvider;
    private final ProjectControl.GenericFactory projectControlFactory;

    @Inject
    RemoveReviewerControl(PermissionBackend permissionBackend, Provider<ReviewDb> dbProvider, ProjectControl.GenericFactory projectControlFactory) {
        this.permissionBackend = permissionBackend;
        this.dbProvider = dbProvider;
        this.projectControlFactory = projectControlFactory;
    }

    public void checkRemoveReviewer(ChangeNotes notes, CurrentUser currentUser, PatchSetApproval approval) throws PermissionBackendException, AuthException, NoSuchProjectException, IOException {
        this.checkRemoveReviewer(notes, currentUser, approval.getAccountId(), approval.getValue());
    }

    public void checkRemoveReviewer(ChangeNotes notes, CurrentUser currentUser, Account.Id reviewer) throws PermissionBackendException, AuthException, NoSuchProjectException, IOException {
        this.checkRemoveReviewer(notes, currentUser, reviewer, 0);
    }

    public boolean testRemoveReviewer(ChangeData cd, CurrentUser currentUser, Account.Id reviewer, int value) throws PermissionBackendException, NoSuchProjectException, OrmException, IOException {
        if (this.canRemoveReviewerWithoutPermissionCheck(cd.change(), currentUser, reviewer, value)) {
            return true;
        }
        return ((PermissionBackend.ForChange)this.permissionBackend.user(currentUser).change(cd).database(this.dbProvider)).test(ChangePermission.REMOVE_REVIEWER);
    }

    private void checkRemoveReviewer(ChangeNotes notes, CurrentUser currentUser, Account.Id reviewer, int val) throws PermissionBackendException, NoSuchProjectException, AuthException, IOException {
        if (this.canRemoveReviewerWithoutPermissionCheck(notes.getChange(), currentUser, reviewer, val)) {
            return;
        }
        ((PermissionBackend.ForChange)this.permissionBackend.user(currentUser).change(notes).database(this.dbProvider)).check(ChangePermission.REMOVE_REVIEWER);
    }

    private boolean canRemoveReviewerWithoutPermissionCheck(Change change, CurrentUser currentUser, Account.Id reviewer, int value) throws NoSuchProjectException, IOException {
        ProjectControl ctl;
        if (change.getStatus().equals((Object)Change.Status.MERGED)) {
            return false;
        }
        if (currentUser.isIdentifiedUser()) {
            Account.Id aId = currentUser.getAccountId();
            if (aId.equals(reviewer)) {
                return true;
            }
            if (aId.equals(change.getOwner()) && 0 <= value) {
                return true;
            }
        }
        return (ctl = this.projectControlFactory.controlFor(change.getProject(), currentUser)).controlForRef(change.getDest()).isOwner() || ctl.isOwner() || ctl.isAdmin();
    }
}

